<?php
/**
 * OrdersApi
 * PHP version 5
 *
 * @category Class
 * @package  Openpay\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * Integration API
 *
 * No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)
 *
 * OpenAPI spec version: v1
 * 
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 * Swagger Codegen version: 3.0.22
 */
/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace Openpay\Client\Api;

use GuzzleHttp6\Client;
use GuzzleHttp6\ClientInterface;
use GuzzleHttp6\Exception\RequestException;
use GuzzleHttp6\Psr7\MultipartStream;
use GuzzleHttp6\Psr7\Request;
use GuzzleHttp6\RequestOptions;
use Openpay\Client\ApiException;
use Openpay\Client\Configuration;
use Openpay\Client\HeaderSelector;
use Openpay\Client\ObjectSerializer;

/**
 * OrdersApi Class Doc Comment
 *
 * @category Class
 * @package  Openpay\Client
 * @author   Swagger Codegen team
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class OrdersApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation ordersLimitsGet
     *
     * Gets the configured minimum and maximum purchase price for orders with the authenticated retailer
     *
     * @param  string $origin origin (optional)
     * 
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsLimits
     */
    public function ordersLimitsGet($origin = null)
    {
        list($response) = $this->ordersLimitsGetWithHttpInfo($origin);
        return $response;
    }

    /**
     * Operation ordersLimitsGetWithHttpInfo
     *
     * Gets the configured minimum and maximum purchase price for orders with the authenticated retailer
     *
     * @param  string $origin (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsLimits, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersLimitsGetWithHttpInfo($origin = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsLimits';
        $request = $this->ordersLimitsGetRequest($origin);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsLimits',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersLimitsGetAsync
     *
     * Gets the configured minimum and maximum purchase price for orders with the authenticated retailer
     *
     * @param  string $origin (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersLimitsGetAsync($origin = null)
    {
        return $this->ordersLimitsGetAsyncWithHttpInfo($origin)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersLimitsGetAsyncWithHttpInfo
     *
     * Gets the configured minimum and maximum purchase price for orders with the authenticated retailer
     *
     * @param  string $origin (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersLimitsGetAsyncWithHttpInfo($origin = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsLimits';
        $request = $this->ordersLimitsGetRequest($origin);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersLimitsGet'
     *
     * @param  string $origin (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersLimitsGetRequest($origin = null)
    {

        $resourcePath = '/orders/limits';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        if ($origin !== null) {
            $queryParams['origin'] = ObjectSerializer::toQueryValue($origin, null);
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersOrderIdCancelPost
     *
     * Cancels the lodgement of a PosApp order
     *
     * @param  string $order_id order_id (required)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsOrder
     */
    public function ordersOrderIdCancelPost($order_id)
    {
        list($response) = $this->ordersOrderIdCancelPostWithHttpInfo($order_id);
        return $response;
    }

    /**
     * Operation ordersOrderIdCancelPostWithHttpInfo
     *
     * Cancels the lodgement of a PosApp order
     *
     * @param  string $order_id (required)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersOrderIdCancelPostWithHttpInfo($order_id)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsOrder';
        $request = $this->ordersOrderIdCancelPostRequest($order_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersOrderIdCancelPostAsync
     *
     * Cancels the lodgement of a PosApp order
     *
     * @param  string $order_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdCancelPostAsync($order_id)
    {
        return $this->ordersOrderIdCancelPostAsyncWithHttpInfo($order_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersOrderIdCancelPostAsyncWithHttpInfo
     *
     * Cancels the lodgement of a PosApp order
     *
     * @param  string $order_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdCancelPostAsyncWithHttpInfo($order_id)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsOrder';
        $request = $this->ordersOrderIdCancelPostRequest($order_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersOrderIdCancelPost'
     *
     * @param  string $order_id (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersOrderIdCancelPostRequest($order_id)
    {
        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling ordersOrderIdCancelPost'
            );
        }

        $resourcePath = '/orders/{orderId}/cancel';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersOrderIdCapturePost
     *
     * Requests that the payment for an order is captured.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCapture $body The options necessary to capture the order (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsCapturedOrder
     */
    public function ordersOrderIdCapturePost($order_id, $body = null)
    {
        list($response) = $this->ordersOrderIdCapturePostWithHttpInfo($order_id, $body);
        return $response;
    }

    /**
     * Operation ordersOrderIdCapturePostWithHttpInfo
     *
     * Requests that the payment for an order is captured.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCapture $body The options necessary to capture the order (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsCapturedOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersOrderIdCapturePostWithHttpInfo($order_id, $body = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsCapturedOrder';
        $request = $this->ordersOrderIdCapturePostRequest($order_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsCapturedOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersOrderIdCapturePostAsync
     *
     * Requests that the payment for an order is captured.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCapture $body The options necessary to capture the order (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdCapturePostAsync($order_id, $body = null)
    {
        return $this->ordersOrderIdCapturePostAsyncWithHttpInfo($order_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersOrderIdCapturePostAsyncWithHttpInfo
     *
     * Requests that the payment for an order is captured.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCapture $body The options necessary to capture the order (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdCapturePostAsyncWithHttpInfo($order_id, $body = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsCapturedOrder';
        $request = $this->ordersOrderIdCapturePostRequest($order_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersOrderIdCapturePost'
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCapture $body The options necessary to capture the order (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersOrderIdCapturePostRequest($order_id, $body = null)
    {
        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling ordersOrderIdCapturePost'
            );
        }

        $resourcePath = '/orders/{orderId}/capturepayment';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json-patch+json', 'application/json', 'text/json', 'application/_*+json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersOrderIdDispatchPost
     *
     * Requests that an order is dispatched.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsOrder
     */
    public function ordersOrderIdDispatchPost($order_id)
    {
        list($response) = $this->ordersOrderIdDispatchPostWithHttpInfo($order_id);
        return $response;
    }

    /**
     * Operation ordersOrderIdDispatchPostWithHttpInfo
     *
     * Requests that an order is dispatched.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersOrderIdDispatchPostWithHttpInfo($order_id)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsOrder';
        $request = $this->ordersOrderIdDispatchPostRequest($order_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersOrderIdDispatchPostAsync
     *
     * Requests that an order is dispatched.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdDispatchPostAsync($order_id)
    {
        return $this->ordersOrderIdDispatchPostAsyncWithHttpInfo($order_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersOrderIdDispatchPostAsyncWithHttpInfo
     *
     * Requests that an order is dispatched.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdDispatchPostAsyncWithHttpInfo($order_id)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsOrder';
        $request = $this->ordersOrderIdDispatchPostRequest($order_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersOrderIdDispatchPost'
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersOrderIdDispatchPostRequest($order_id)
    {
        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling ordersOrderIdDispatchPost'
            );
        }

        $resourcePath = '/orders/{orderId}/dispatch';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersOrderIdGet
     *
     * Gets an order by order id.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsGetOrder
     */
    public function ordersOrderIdGet($order_id)
    {
        list($response) = $this->ordersOrderIdGetWithHttpInfo($order_id);
        return $response;
    }

    /**
     * Operation ordersOrderIdGetWithHttpInfo
     *
     * Gets an order by order id.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsGetOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersOrderIdGetWithHttpInfo($order_id)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsGetOrder';
        $request = $this->ordersOrderIdGetRequest($order_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsGetOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersOrderIdGetAsync
     *
     * Gets an order by order id.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdGetAsync($order_id)
    {
        return $this->ordersOrderIdGetAsyncWithHttpInfo($order_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersOrderIdGetAsyncWithHttpInfo
     *
     * Gets an order by order id.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdGetAsyncWithHttpInfo($order_id)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsGetOrder';
        $request = $this->ordersOrderIdGetRequest($order_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersOrderIdGet'
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersOrderIdGetRequest($order_id)
    {
        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling ordersOrderIdGet'
            );
        }

        $resourcePath = '/orders/{orderId}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersOrderIdRefundPost
     *
     * Requests that an order is partially or fully refunded.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsRefund $body body (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsRefundOrder
     */
    public function ordersOrderIdRefundPost($order_id, $body = null)
    {
        list($response) = $this->ordersOrderIdRefundPostWithHttpInfo($order_id, $body);
        return $response;
    }

    /**
     * Operation ordersOrderIdRefundPostWithHttpInfo
     *
     * Requests that an order is partially or fully refunded.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsRefund $body (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsRefundOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersOrderIdRefundPostWithHttpInfo($order_id, $body = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsRefundOrder';
        $request = $this->ordersOrderIdRefundPostRequest($order_id, $body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsRefundOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersOrderIdRefundPostAsync
     *
     * Requests that an order is partially or fully refunded.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsRefund $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdRefundPostAsync($order_id, $body = null)
    {
        return $this->ordersOrderIdRefundPostAsyncWithHttpInfo($order_id, $body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersOrderIdRefundPostAsyncWithHttpInfo
     *
     * Requests that an order is partially or fully refunded.
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsRefund $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersOrderIdRefundPostAsyncWithHttpInfo($order_id, $body = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsRefundOrder';
        $request = $this->ordersOrderIdRefundPostRequest($order_id, $body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersOrderIdRefundPost'
     *
     * @param  string $order_id The Order ID that was returned when the order was created (required)
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsRefund $body (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersOrderIdRefundPostRequest($order_id, $body = null)
    {
        // verify the required parameter 'order_id' is set
        if ($order_id === null || (is_array($order_id) && count($order_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $order_id when calling ordersOrderIdRefundPost'
            );
        }

        $resourcePath = '/orders/{orderId}/refund';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;


        // path params
        if ($order_id !== null) {
            $resourcePath = str_replace(
                '{' . 'orderId' . '}',
                ObjectSerializer::toPathValue($order_id),
                $resourcePath
            );
        }

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json-patch+json', 'application/json', 'text/json', 'application/_*+json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation ordersPost
     *
     * Requests creation of a new order.
     *
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCreateOrder $body The options necessary to initiate the order for a new plan (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Openpay\Client\Model\IntegrationApiModelsCreatedOrder
     */
    public function ordersPost($body = null)
    {
        list($response) = $this->ordersPostWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation ordersPostWithHttpInfo
     *
     * Requests creation of a new order.
     *
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCreateOrder $body The options necessary to initiate the order for a new plan (optional)
     *
     * @throws \Openpay\Client\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Openpay\Client\Model\IntegrationApiModelsCreatedOrder, HTTP status code, HTTP response headers (array of strings)
     */
    public function ordersPostWithHttpInfo($body = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsCreatedOrder';
        $request = $this->ordersPostRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? $e->getResponse()->getBody()->getContents() : null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    $response->getBody()
                );
            }

            $responseBody = $response->getBody();
            if ($returnType === '\SplFileObject') {
                $content = $responseBody; //stream goes to serializer
            } else {
                $content = $responseBody->getContents();
                if (!in_array($returnType, ['string','integer','bool'])) {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 201:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\IntegrationApiModelsCreatedOrder',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
                case 422:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Openpay\Client\Model\MicrosoftAspNetCoreMvcProblemDetails',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation ordersPostAsync
     *
     * Requests creation of a new order.
     *
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCreateOrder $body The options necessary to initiate the order for a new plan (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersPostAsync($body = null)
    {
        return $this->ordersPostAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation ordersPostAsyncWithHttpInfo
     *
     * Requests creation of a new order.
     *
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCreateOrder $body The options necessary to initiate the order for a new plan (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Promise\PromiseInterface
     */
    public function ordersPostAsyncWithHttpInfo($body = null)
    {
        $returnType = '\Openpay\Client\Model\IntegrationApiModelsCreatedOrder';
        $request = $this->ordersPostRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    $responseBody = $response->getBody();
                    if ($returnType === '\SplFileObject') {
                        $content = $responseBody; //stream goes to serializer
                    } else {
                        $content = $responseBody->getContents();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'ordersPost'
     *
     * @param  \Openpay\Client\Model\IntegrationApiModelsCommandsCreateOrder $body The options necessary to initiate the order for a new plan (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp6\Psr7\Request
     */
    protected function ordersPostRequest($body = null)
    {

        $resourcePath = '/orders';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json-patch+json', 'application/json', 'text/json', 'application/_*+json']
            );
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            // $_tempBody is the method argument, if present
            $httpBody = $_tempBody;
            // \stdClass has no __toString(), so we should encode it manually
            if ($httpBody instanceof \stdClass && $headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($httpBody);
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $multipartContents[] = [
                        'name' => $formParamName,
                        'contents' => $formParamValue
                    ];
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp6\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = \GuzzleHttp6\Psr7\build_query($formParams);
            }
        }

        // this endpoint requires HTTP basic authentication
        if ($this->config->getUsername() !== null || $this->config->getPassword() !== null) {
            $headers['Authorization'] = 'Basic ' . base64_encode($this->config->getUsername() . ":" . $this->config->getPassword());
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = \GuzzleHttp6\Psr7\build_query($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
