<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

trait OpenpayFrontendHooksTrait
{
    /**
     * Regular Payment Option in PS 1.7.x
     *
     * @param array $params
     * @return array|null
     */
    public function hookPaymentOptions($params)
    {
        if (!$this->isReadyForFrontend()) {
            return;
        }
        if (!$this->active) {
            return;
        }
        if (!$this->checkCurrency($params['cart'])) {
            return;
        }
        $cart = $params['cart'];
        //Don't show Openoay if Price to low or high
        $min = Configuration::get('OPENPAY_MIN');
        $max = Configuration::get('OPENPAY_MAX');
        $total = $cart->getOrderTotal(true, \Cart::BOTH);
        if ($total < $min || $total > $max) {
            return;
        }
        //Don't show Openoay if Products/Categories were excluded
        $excludedProducts = explode(',', Configuration::get('OPENPAY_PRODUCTS'));
        $excludedCategories = explode(',', Configuration::get('OPENPAY_CATEGORIES'));
        if ($excludedProducts || $excludedCategories) {
            foreach($cart->getProducts() as $product) {
                if (in_array($product['id_category_default'], $excludedCategories)) {
                    return;
                } elseif (in_array($product['id_product'], $excludedProducts)) {
                    return;
                }
            }
        }

        $this->smarty->assign(array(
            'openpayCustomText' => Configuration::get('OPENPAY_DESCRIPTION')
        ));
        
        $option = new \PrestaShop\PrestaShop\Core\Payment\PaymentOption();
        $option->setModuleName($this->name)
                ->setCallToActionText(Configuration::get('OPENPAY_TITLE'))
                ->setLogo(Media::getMediaPath(_PS_MODULE_DIR_ . $this->name . '/views/img/openpaylogo.svg'))
                ->setAction($this->context->link->getModuleLink($this->name, 'paymentprocess', array(), true))
                ->setAdditionalInformation($this->fetch('module:openpay/views/templates/hook/embeddedPaymentOption.tpl'));

        return [
            $option
        ];
    }   
    
    public function hookHeader()
    {
        if (isset($this->context->cookie->openpay_error_message)) {
            $this->context->controller->errors[] = $this->context->cookie->openpay_error_message;
            unset($this->context->cookie->openpay_error_message);
        }
        
        return;
    }
}