<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

trait OpenpayBackendHooksTrait
{
    /**
     * adding media to admin login page header
     */
    public function hookActionAdminControllerSetMedia()
    {
        if (Tools::getValue('configure') == $this->name) {
            $this->context->controller->addJquery();
            $this->context->controller->addJS($this->_path.'views/js/admin.js');
        }
    }
    
    /**
     * Refunding
     * 
     * @param array $params
     * @return boolean
     */
    public function hookActionOrderSlipAdd($params) 
    {   
        $orderid = (int)$params['order']->id;
        $order = new Order($orderid);
        $state = $order->getCurrentOrderState();
        if ($params['order']->module != $this->name) {
            return false;
        } elseif (!$state->paid) {
            return false;
        } 
        if (Openpay::isPrestaShop177OrHigher()) {
            $formParams = $_POST;
            $canceledproducts = $formParams['cancel_product'];
            if (isset($canceledproducts['voucher'])) {
                return false;
            }
        } else {
            if (Tools::isSubmit('generateDiscount') || Tools::isSubmit('generateDiscountRefund')) {
                return false;
            }
        }

        $refund_products_list = $params['productList'];
        $full_quantity_list = $params['qtyList'];
        $refund_total_amount = 0;
        
        if (Openpay::isPrestaShop177OrHigher()) {
            foreach ($refund_products_list as $item) {
                $refund_total_amount += (float)$item['total_refunded_tax_incl'];
            }
            if ((int)$canceledproducts['shipping'] >= 1) {
                $refund_total_amount += (float)$params['order']->total_shipping;
            } elseif ((float)$canceledproducts['shipping_amount'] > 0) {
                $refund_total_amount += (float)$canceledproducts['shipping_amount'];
            }
        } else {
            if (Tools::isSubmit('partialRefund')) {
                foreach ($refund_products_list as $item) {
                    $slip = OrderSlipCore::getProductSlipDetail($item['id_order_detail']);
                    usort($slip, function($a, $b) {
                        return strtotime($b['date_add']) - strtotime($a['date_add']);
                    });
                    $refund_total_amount += $slip[0]['amount_tax_incl'];
                }
                $shipping_cost_amount = (float) str_replace(',', '.', Tools::getValue('partialRefundShippingCost')) ? (float) str_replace(',', '.', Tools::getValue('partialRefundShippingCost')) : false;
                if ($shipping_cost_amount > 0) {
                    if (!Tools::getValue('TaxMethod')) {
                        $tax = new Tax();
                        $tax->rate = $order->carrier_tax_rate;
                        $tax_calculator = new TaxCalculator(array($tax));
                        $refund_total_amount += $tax_calculator->addTaxes($shipping_cost_amount);
                    } else {
                        $refund_total_amount += $shipping_cost_amount;
                    }
                } 
            } elseif (Tools::isSubmit('cancelProduct')) {
                foreach ($refund_products_list as $item) {
                    $order_detail = new OrderDetail((int)$item);
                    $amount = $order_detail->unit_price_tax_incl * $full_quantity_list[$item];
                    $refund_total_amount += $amount;
                }
                if (Tools::isSubmit('shippingBack')) {
                    $refund_total_amount += $order->total_shipping;
                }
            }
        }
        $refund_total_amount = round((float)$refund_total_amount, 2);
        
        $refund = $this->_makeRefund($orderid, $refund_total_amount);
        if ($refund == false &&  Openpay::isPrestaShop177OrHigher()) {
            throw new PrestaShop\PrestaShop\Core\Domain\Order\Exception\OrderException($this->l("Refunding wasn't successful"));
        } elseif($refund == false) {
            $this->errors[] = $this->l('In Prestashop refund was successfull. But there was an issue in Openpay and the amount was not updated. Please go to Openpay Portal and refund the amount there.');
        } 
        
        return true;
    }
    
    /**
     * call the Openpay API and update the
     * Openpay Refund Table
     * 
     * @param int $orderid
     * @param float $amt
     * @return boolean
     */
    private function _makeRefund($orderid, $amt)
    {
        $fullRefunded = false;
        $row = OpenpayOrder::getOpenpayOrderByOrderId($orderid);
        if (!isset($row['plan_id']) || $row['plan_id'] == '') {
            return false;
        }
        $planid = $row['plan_id'];
        $currentdate = date('Y-m-d H:i:s');
        OpenpayRefund::store($orderid, $amt, false, $currentdate, $planid);
        $backofficeparams = OpenpayAdminConfigFormHelper::getConfigFormValues();
        try {
            /** @var $paymentmanager \BusinessLayer\Openpay\PaymentManager */
            $sdk = new \BusinessLayer\Openpay\PaymentManager($backofficeparams);
            $sdk->setUrlAttributes([$planid]);
            $response = $sdk->getOrder();
            if ($response->purchasePrice == (int)($amt * 100)) {
                $fullRefunded = true;
            }
            $prices = [
                'newPrice' => 0,
                'reducePriceBy'=> (int)($amt * 100),
                'isFullRefund' => $fullRefunded
            ];
            $sdk->setShopdata(null, $prices);
            $response = $sdk->refund();
            OpenpayRefund::updateStatus($orderid, $currentdate, true);
        } catch (\Exception $e) { 
            OpenpayLogger::getInstance()->addLog($e->getMessage());
            return false;
        }
        
        if ($fullRefunded) {
            self::updateStatus($orderid, 'PS_OS_REFUND');
        }
        
        return true;
    }
    
    /**
     * Display new Openpay Element for partial refund in
     * the Back Office Order detail page
     *
     * @param array $params
     */
    public function hookDisplayAdminOrder($params)
    {   
        if (Openpay::isPrestaShop177OrHigher()) {
            return;
        }
        
        return $this->hookDisplayAdminOrderMain($params);
    }
    
    /**
     * Display new Openpay Element for partial refund in
     * the Back Office Order detail page for Prestashop 1.7.7
     *
     * @param array $params
     */
    public function hookDisplayAdminOrderMain($params)
    {
        $order = new Order($params['id_order']);
        if ($order->module == $this->name && isset($order->id)) {
            $openpayorder = OpenpayOrder::getOpenpayOrderByOrderId($order->id);
            $planid = (!isset($openpayorder['plan_id'])) ? '' : $openpayorder['plan_id'];
            $this->context->smarty->assign(array(
                'list_refunds' => OpenpayRefund::getOpenpayRefundByOrderId($order->id),
                'planid' => $planid,
                'isHigher176' => Openpay::isPrestaShop177OrHigher()
            ));
            
            return $this->display($this->this_file, 'views/templates/admin/refund.tpl');
        }
    }
    
    private static function updateStatus($orderid, $status)
    {
        $history = new OrderHistory();
        $history->id_order = $orderid;
        $history->changeIdOrderState((int)Configuration::get($status), $orderid);
        $history->add();
    }
}
