<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayLogger 
{
    /**
     * @var OpenpayLogger
     */
    public static $instance = false;

    /**
     * Add message to Logfile
     *
     * @param $message
     */
    public function addLog($message) 
    {
        $backtrace = debug_backtrace();
        $fileinfo = '';
        $callsinfo = '';
        if (!empty($backtrace[0]) && is_array($backtrace[0])) {
            $fileinfo = $backtrace[0]['file'] . ": " . $backtrace[0]['line'];
            for ($x=1; $x<5; $x++) {
                if (!empty($backtrace[$x]) && is_array($backtrace[$x])) {
                    $callsinfo.= "\r\n" . $backtrace[$x]['file'] . ": " . $backtrace[$x]['line'];
                }
            }
        }
        $logstr = date("Y-m-d H:i:s");
        $logstr.= ' [DEBUG] ';
        $logstr.= $message;
        $logstr.= ' - ' . $fileinfo;
        $logstr.= "\r\n";
        if ($callsinfo != '') {
            $logstr.= 'Backtrace :';
            $logstr.= $callsinfo . "\r\n";
        }
        $this->writeToLogfile($logstr);
        PrestaShopLogger::addLog($message, 3, null, 'Openpay');
    }

    /**
     * Write Logfile for debugging purposes
     *
     * @param string $string
     */
    protected function writeToLogfile($string)
    {
        file_put_contents($this->getLogFileName(), $string, FILE_APPEND);
    }


    /**
     * @return string
     */
    protected function getLogDir()
    {
        if (is_dir(_PS_ROOT_DIR_.'/log')) {
            return _PS_ROOT_DIR_.'/log/';
        } elseif (is_dir(_PS_ROOT_DIR_ . '/app/logs')) {
            return _PS_ROOT_DIR_.'/app/logs/';
        } else {
            return _PS_ROOT_DIR_.'/var/logs/';
        }
    }

    /**
     * @return string
     */
    protected function getLogFileName()
    {
        return $this->getLogDir() . 'openpay.log';
    }

    /**
     * @return OpenpayLogger
     */
    public static function getInstance()
    {
        if (!self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    /**
     * @return array
     */
    protected function getConfigFormValuesForDebug()
    {
        $vars = AmazonPayAdminConfigFormHelper::getConfigFormValues();
        return $vars;
    }

    /**
     * @return false|string
     */
    public function getLogContent()
    {
        $debuginfo = array(
            'PrestaShop Version' => _PS_VERSION_,
            'PrestaShop URL' => _PS_BASE_URL_,
            'PrestaShop URL SSL' => _PS_BASE_URL_SSL_,
            'SSL State' => Configuration::get('PS_SSL_ENABLED') ? '1' : '0',
            'Plugin Version' => Amazonpay::$plugin_version,
            'Configuration options' => $this->getConfigFormValuesForDebug(),
        );

        $debuginfo = "\r\n\r\n" . "DEBUG INFO: " . "\r\n\r\n" . print_r($debuginfo, true);

        if (file_exists($this->getLogFileName())) {
            return $debuginfo . "\r\n\r\n" . Tools::file_get_contents($this->getLogFileName());
        }
        return $debuginfo;
    }
}
