<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayCronHelper
{
    /**
     * return array with min and max values of response or an error with
     * error message
     * 
     * @param array $backofficeparams
     * @return array
     */
    public static function getLimits($backofficeparams)
    {
        $response = [];
        try { 
            // get existing value of min and max from backofficeparams
            $min = Configuration::get('OPENPAY_MIN');
            $max = Configuration::get('OPENPAY_MAX');

            /** @var $paymentmanager \BusinessLayer\Openpay\PaymentManager */
            $sdk = new \BusinessLayer\Openpay\PaymentManager($backofficeparams);
            $sdk->setUrlAttributes(array('online'));
            $config = $sdk->getConfiguration();

            // get values from openpay pay api
            $minValue = ((int)$config->minPrice)/100;
            $maxValue = ((int)$config->maxPrice)/100;
            
            $response = ['min' => $minValue, 'max' => $maxValue];
        } catch (\Exception $e) {
            $response['message'] = $e->getMessage();
            OpenpayLogger::getInstance()->addLog($e->getMessage());
        }
        
        return $response;
    }
    
    /**
     * read all orders with Status Preperation and
     * cancel or active status depend on openpay response
     * 
     * @param array $backofficeparams
     */
    public function updateOrderStatus($backofficeparams)
    {
        $orders = Db::getInstance()->executeS(
            "SELECT id_order " .
            "FROM " . _DB_PREFIX_ . "orders " .
            "WHERE module = 'openpay' " .
            "AND current_state = " . (int)Configuration::get('PS_OS_PREPARATION')
        );
        if ($orders) {
            self::changeOrderStatus($orders, $backofficeparams);
        }
    }
        
    /**
     * change status in Prestashop
     * 
     * @param array $orders
     * @param array $backofficeparams
     */
    private static function changeOrderStatus($orders, $backofficeparams)
    {
        $frequency = (Configuration::get('OPENPAY_JOB_FREQUENCYE')) ? intval(Configuration::get('OPENPAY_JOB_FREQUENCYE')) : 30;
        $dateNow = new DateTime();
        $dateNow->sub(new DateInterval('PT' . $frequency . 'M'));
        $now = $dateNow->format('Y-m-d H:i:s');
        foreach($orders as $orderid) {
            $order = new Order($orderid['id_order']);
            if (strtotime($order->date_add) < strtotime($now)) {
                $history = new OrderHistory();
                $history->id_order = $orderid['id_order'];

                $row = OpenpayOrder::getOpenpayOrderByOrderId($orderid['id_order']);
                if (!empty($row)) {
                    try {
                        /** @var $paymentmanager \BusinessLayer\Openpay\PaymentManager */
                        $sdk = new \BusinessLayer\Openpay\PaymentManager($backofficeparams);
                        $sdk->setUrlAttributes([$row['plan_id']]);
                        $response = $sdk->getOrder();
                    } catch (\Exception $e) { 
                        $message = $e->getMessage();
                        if (strpos($message, 'Error 12704') !== false) {
                           $history->changeIdOrderState((int)Configuration::get('PS_OS_CANCELED'), $row['id_order']);
                           $history->add();
                        } else {
                           OpenpayLogger::getInstance()->addLog('UpdateOrderStatusJob: ' . $e->getMessage());
                        }
                    }
                    if ($response->orderStatus == 'Approved' && $response->planStatus == 'Active') {
                        $history->changeIdOrderState((int)Configuration::get('PS_OS_PAYMENT'), $row['id_order']);
                        $history->add();
                    } else {
                        $history->changeIdOrderState((int)Configuration::get('PS_OS_CANCELED'), $row['id_order']);
                        $history->add();
                    }
                }
            }
        }
    }
}
