<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayAdminConfigFormHelper 
{
    /**
     * Configuration form itself is displayed
     * 
     * @return HelperFormCore
     */
    public static function renderForm($module)
    {
        $helper = new HelperForm();

        $helper->show_toolbar = false;
        $helper->table = $module->getVar('table');
        $helper->module = $module;
        $helper->default_form_language = $module->getVar('context')->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);

        $helper->identifier = $module->getVar('identifier');
        $helper->submit_action = 'submitOpenpayModel';
        $helper->currentIndex = $module->getVar('context')->link->getAdminLink('AdminModules', false)
            .'&configure='.$module->getVar('name').'&tab_module='.$module->getVar('tab').'&module_name='.$module->getVar('name');
        $helper->token = Tools::getAdminTokenLite('AdminModules');

        $helper->tpl_vars = array(
            'fields_value' => self::getConfigFormValues(),
            'languages' => $module->getVar('context')->controller->getLanguages(),
            'id_language' => $module->getVar('context')->language->id,
        );
        
        return $helper->generateForm(
            array(
                self::getSettingForm($module)
            )
        );
    }
    
    /**
     * get Config values which are saved in Database 
     * 
     * 
     * @return array
     */
    public static function getConfigFormValues()
    {
        return array(
            'OPENPAY_ACTIVE' => Configuration::get('OPENPAY_ACTIVE'),
            'OPENPAY_TITLE' => Configuration::get('OPENPAY_TITLE'),
            'OPENPAY_DESCRIPTION' => Configuration::get('OPENPAY_DESCRIPTION'),
            'OPENPAY_MODE' => Configuration::get('OPENPAY_MODE'),
            'OPENPAY_REGION' => Configuration::get('OPENPAY_REGION'),
            'OPENPAY_USER' => Configuration::get('OPENPAY_USER'),
            'OPENPAY_PASSWORD' => Configuration::get('OPENPAY_PASSWORD'),
            'OPENPAY_MIN' => Configuration::get('OPENPAY_MIN'),
            'OPENPAY_MAX' => Configuration::get('OPENPAY_MAX'),
            'OPENPAY_FREQUENCY' => Configuration::get('OPENPAY_FREQUENCY'),
            'OPENPAY_CATEGORIES' => Configuration::get('OPENPAY_CATEGORIES'),
            'OPENPAY_PRODUCTS' => Configuration::get('OPENPAY_PRODUCTS'),
        );
    }
    
    /**
     * form block Settings
     * 
     * @return array
     */
    protected static function getSettingForm(Openpay $module)
    {
        return array(
            'form' => array(
                'legend' => array(
                    'title' => $module->l('Openpay Settings'),
                    'icon' => 'icon-cogs',
                ),
                'input' => array(
                    array(
                        'type' => 'switch',
                        'label' => $module->l('Active'),
                        'name' => 'OPENPAY_ACTIVE',
                        'is_bool' => true,
                        'desc' => $module->l('Accept payments with Openpay'),
                        'values' => array(
                            array(
                                'id' => 'active_on',
                                'value' => true,
                                'label' => $module->l('Enabled')
                            ),
                            array(
                                'id' => 'active_off',
                                'value' => false,
                                'label' => $module->l('Disabled')
                            )
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Title'),
                        'name' => 'OPENPAY_TITLE',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Description'),
                        'name' => 'OPENPAY_DESCRIPTION',
                        'required' => true
                    ),
                    array(
                        'type' => 'select',
                        'label' => $module->l('Mode'),
                        'name' => 'OPENPAY_MODE',
                        'options' => array(
                            'query' => array(
                                array(
                                    'mode' => 'test',
                                    'name' => $module->l('Sandbox')
                                ),
                                array(
                                    'mode' => 'live',
                                    'name' => $module->l('Production')
                                )
                            ),
                            'id' => 'mode',
                            'name' => 'name'
                        ),
                    ),
                    array(
                        'type' => 'select',
                        'label' => $module->l('Region'),
                        'name' => 'OPENPAY_REGION',
                        'options' => array(
                            'query' => array(
                                array(
                                    'region' => 'Au',
                                    'name' => $module->l('Australia')
                                ),
                                array(
                                    'region' => 'En',
                                    'name' => $module->l('United Kingdom')
                                )
                            ),
                            'id' => 'region',
                            'name' => 'name'
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Openpay Username'),
                        'name' => 'OPENPAY_USER',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Openpay Password'),
                        'name' => 'OPENPAY_PASSWORD',
                        'required' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Minimum Checkout Value'),
                        'name' => 'OPENPAY_MIN',
                        'required' => true,
                        'readonly' => true
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Maximum Checkout Value'),
                        'name' => 'OPENPAY_MAX',
                        'required' => true,
                        'readonly' => true
                    ),
                    array(
                        'type' => 'html',
                        'name' => 'openpay_button',
                        'html_content' => 
                            '<button type="button" class="btn btn-default" onclick="updateOpenpayMinMax()">Run Min/Max !</button>'
                            . '&nbsp;<img src="' . $module->getVar('_path') . '/views/img/ajax-loader.gif" id="loaderDiv" style="display: none;"/>'
                            . '<span id="custom_message_span"></span>'
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Update Pending order older than'),
                        'name' => 'OPENPAY_FREQUENCY',
                        'required' => false,
                        'disabled' => true
                    ),
                    array(
                        'type' => 'categories',
                        'label' => $module->l('Disabled Categories'),
                        'name'  => 'OPENPAY_CATEGORIES',
                        'tree'  => array(
                            'id' => 'OPENPAY_CATEGORIES',
                            'selected_categories' => explode(',', Configuration::get('OPENPAY_CATEGORIES')),
                            'use_checkbox' => true
                        )
                    ),
                    array(
                        'type' => 'text',
                        'label' => $module->l('Disabled Products'),
                        'name' => 'OPENPAY_PRODUCTS',
                        'desc' => $module->l('Add Product ids with comma seperated.'),
                        'required' => false
                    )
                ),
                'submit' => array(
                    'title' => $module->l('Save'),
                )
            )
        );
    }
}
