<?php
/**
* 2020 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayRefund extends ObjectModel
{
    public $order_id;
    
    public $product_id;
    
    public $plan_id;
    
    public $refund_amount;
    
    public $date_upd;
    
    public $status;
    
    public static $definition = array(
        'table' => 'openpay_refund',
        'primary' => 'id',
        'fields' => array(
            'order_id' => array(
                'type' => self::TYPE_INT
            ),
            'product_id' => array(
                'type' => self::TYPE_INT
            ),
            'plan_id' => array(
                'type' => self::TYPE_STRING,
                'size' => 255
            ),
            'refund_amount' => array(
                'type' => self::TYPE_FLOAT
            ),
            'date_upd' => array(
                'type' => self::TYPE_DATE
            ),
            'status' => array(
                'type' => self::TYPE_BOOL
            )    
        )
    );
    
    /**
     * save Refund transaction in the table
     * 
     * @param int $idOrder
     * @param float $amount
     * @param boolean $status
     * @param string $date
     * @param string $planid
     * @param int $idProduct
     * @return OpenpayRefund
     */
    public static function store($idOrder, $amount, $status, $date, $planid, $idProduct=0)
    {
        $tx = new self();
        $tx->order_id = $idOrder;
        $tx->refund_amount = $amount;
        $tx->status = $status;
        $tx->date_upd = $date;
        $tx->plan_id = $planid;
        $tx->product_id = $idProduct;
        $tx->add();
        
        return $tx;
    }
    
    /**
     * select all refunds from special order
     * 
     * @param int $orderid
     * @return array
     */
    public static function getOpenpayRefundByOrderId($orderid)
    {
        $sql = "SELECT * FROM `" . _DB_PREFIX_ . "openpay_refund`"
               . " WHERE `order_id` = " . $orderid 
               . " ORDER BY `date_upd` DESC";
        $result = Db::getInstance()->executeS($sql);
        
        if ($result && is_array($result) && sizeof($result) > 0) {
            return $result;
        }
        
        return [];
    }
    
    /**
     * Update status of OpenpayRefund
     * 
     * @param int $orderid
     * @param string $date
     * @param boolean $status
     */
    public static function updateStatus($orderid, $date, $status)
    {
        Db::getInstance()->update(
            'openpay_refund',
            array(
                'status' => pSQL($status)
            ),
            'order_id = ' . $orderid . ' AND date_upd = \'' . $date . '\''
        );
    }
}
