<?php
/**
* 2020 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayOrder extends ObjectModel
{   
    public $id_order;
    
    public $plan_id;
    
    public static $definition = array(
        'table' => 'openpay_orders',
        'primary' => 'id',
        'fields' => array(
            'id_order' => array(
                'type' => self::TYPE_INT
            ),
            'plan_id' => array(
                'type' => self::TYPE_STRING,
                'size' => 255
            )
        )
    );
    
    /**
     * @param $idOrder
     * @param $plan_id
     * @return OpenpayOrder
     * @throws PrestaShopDatabaseException
     * @throws PrestaShopException
     */
    public static function store($idOrder, $plan_id)
    {
        $tx = new self();
        $tx->id_order = $idOrder;
        $tx->plan_id = $plan_id;
        $tx->add();
        
        return $tx;
    }
    
    /**
     * get the Order by orderid
     * 
     * @param int $orderid
     * @return array
     */
    public static function getOpenpayOrderByOrderId($orderid)
    {
        $sql  = 'SELECT * FROM `' . _DB_PREFIX_ . 'openpay_orders` WHERE `id_order` = ' . $orderid;
        $result = Db::getInstance()->getRow($sql);  
        if ($result && is_array($result) && sizeof($result) > 0) {
            return $result;
        }
        
        return [];
    }
}
