<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

use PrestaShop\PrestaShop\Core\Payment\PaymentOption;

if (!defined('_PS_VERSION_')) {
    exit;
}

require_once(dirname(__FILE__) . '/src/classes/Helper/OpenpayAdminConfigFormHelper.php');
require_once(dirname(__FILE__) . '/src/classes/Helper/OpenpayCronHelper.php');
require_once(dirname(__FILE__) . '/src/traits/OpenpayFrontendHooksTrait.php');
require_once(dirname(__FILE__) . '/src/traits/OpenpayBackendHooksTrait.php');
require_once(dirname(__FILE__) . '/src/classes/OpenpayLogger.php');
require_once(dirname(__FILE__) . '/src/classes/Entities/OpenpayOrder.php');
require_once(dirname(__FILE__) . '/src/classes/Entities/OpenpayRefund.php');
require_once(dirname(__FILE__) . '/vendor/OpenpayApi/vendor/autoload.php');

class Openpay extends PaymentModule
{
    use OpenpayFrontendHooksTrait;
    use OpenpayBackendHooksTrait;
    
    protected $_html = '';
    protected $this_file = __FILE__;
    public $_postSuccess = array();
    public $_postError = array();

    /**
     * Openpay constructor.
     */
    public function __construct()
    {
        $this->name = 'openpay';
        $this->tab = 'payments_gateways';
        $this->version = '1.1.0';
        $this->ps_versions_compliancy = array('min' => '1.7.1.0', 'max' => _PS_VERSION_);
        $this->author = 'Ideatarmac';
        $this->controllers = array('paymentprocess', 'validation');
        $this->is_eu_compatible = 1;

        $this->currencies = true;
        $this->currencies_mode = 'checkbox';

        $this->bootstrap = true;
        parent::__construct();

        $this->displayName = $this->l('Openpay');
        $this->description = $this->l('Buy now, pay smarter');
        $this->confirmUninstall = $this->l('Are you sure about removing these details?');
        
        if (!count(Currency::checkPaymentCurrencies($this->id))) {
            $this->warning = $this->l('No currency has been set for this module.');
        }
    }
    
    /**
     * @return bool
     */
    public function install()
    {
        include(dirname(__FILE__).'/sql/install.php');
        
        if (parent::install() == false ||
            $this->registerHook('paymentOptions') == false ||
            $this->registerHook('header') == false ||
            $this->registerHook('paymentReturn') == false ||
            $this->registerHook('displayAdminOrder') == false ||
            $this->registerHook('actionOrderStatusUpdate') == false ||
            $this->registerHook('backOfficeHeader') == false ||
            $this->registerHook('actionAdminControllerSetMedia') == false ||
            $this->registerHook('actionOrderSlipAdd') == false ||
            $this->registerHook('displayAdminOrderMain') == false ||
            $this->setDefaults() == false
            ) {
            return false;
        }
        
        return true;
    }
    
    /**
     * @return bool
     */
    public function uninstall()
    {
        Configuration::deleteByName('OPENPAY_ACTIVE');
        Configuration::deleteByName('OPENPAY_TITLE');
        Configuration::deleteByName('OPENPAY_DESCRIPTION');
        Configuration::deleteByName('OPENPAY_USER');
        Configuration::deleteByName('OPENPAY_PASSWORD');
        Configuration::deleteByName('OPENPAY_MODE');
        Configuration::deleteByName('OPENPAY_REGION');
        Configuration::deleteByName('OPENPAY_MIN');
        Configuration::deleteByName('OPENPAY_MAX');
        Configuration::deleteByName('OPENPAY_CATEGORIES');
        Configuration::deleteByName('OPENPAY_PRODUCTS');
        Configuration::deleteByName('OPENPAY_FREQUENCY');
        
        return parent::uninstall();
    }
    
    /**
     * @param string $var
     * @return mixed|null
     */
    public function getVar($var)
    {
        if (isset($this->$var)) {
            return $this->$var;
        }
        return null;
    }
    
    /**
     * sets default config values
     */
    public function setDefaults()
    {
        Configuration::updateValue('OPENPAY_TITLE', 'Openpay - Buy now. Pay smarter.');
        Configuration::updateValue('OPENPAY_FREQUENCY', 30);
        Configuration::updateValue('OPENPAY_MODE', 'test');
        Configuration::updateValue('OPENPAY_REGION', 'Au');
        
        return true;
    }
    
    /**
     * Adding configuration page
     * 
     * @return string
     */
    public function getContent()
    {   
        $this->addJsDefList();
        if (((bool)Tools::isSubmit('submitOpenpayModel')) == true) {
            $this->postProcess();
            if (count($this->_postSuccess)) {
                $this->context->smarty->assign(array('postSuccess' => $this->_postSuccess));
            }
            if (count($this->_postError)) {
                $this->context->smarty->assign(array('postError' => $this->_postError));
            }
        }
        $this->context->smarty->assign('postSuccess', $this->_postSuccess);
        $output = $this->context->smarty->fetch($this->local_path . 'views/templates/admin/configure.tpl');
        $form = OpenpayAdminConfigFormHelper::renderForm($this);
        
        return $output . $form;
    }
    
    /**
     * Save form data
     */
    protected function postProcess()
    {
        $form_values = OpenpayAdminConfigFormHelper::getConfigFormValues();
        foreach (array_keys($form_values) as $key) {
            if ($key == 'OPENPAY_CATEGORIES') {
                $catValues = (Tools::getValue($key)) ? implode(',', Tools::getValue($key)) : '';
                Configuration::updateValue($key, $catValues);
            } elseif ($key !== 'OPENPAY_FREQUENCY') {
                Configuration::updateValue($key, Tools::getValue($key));
            }   
        }
        $this->_postSuccess[] = $this->l('Settings updated');
    }
    
    /**
     * @return boolean
     */
    protected function isReadyForFrontend()
    {
        $isReady = false;
        if (!empty(Configuration::get('OPENPAY_ACTIVE')) &&
            !empty(Configuration::get('OPENPAY_USER')) &&
            !empty(Configuration::get('OPENPAY_PASSWORD'))) {
            $isReady = true;    
        }
        
        return $isReady;
    }
    
    /**
     * @param $cart
     * @return bool
     */
    public function checkCurrency($cart)
    {
        $currency_order = new Currency($cart->id_currency);
        $currencies_module = $this->getCurrency($cart->id_currency);
        if (is_array($currencies_module)) {
            foreach ($currencies_module as $currency_module) {
                if ($currency_order->id == $currency_module['id_currency']) {
                    return true;
                }
            }
        }
        return false;
    }
    
    /**
     * Add a new javascript definition at bottom of page.
     */
    protected function addJsDefList()
    {
        Media::addJsDef(array(
            'minmaxcontrollerurl' => $this->context->link->getModuleLink('openpay', 'minmax')
        ));
    }
    
    /**
     * @return bool
     */
    public static function isPrestaShop177OrHigher()
    {
        return version_compare(_PS_VERSION_, '1.7.7', '>=');
    }
}