<?php

/**

 * @example openpay_price_truncate(-1.49999, 2); // returns -1.49

 * @example openpay_price_truncate(.49999, 3); // returns 0.499

 * @param float $val

 * @param int f

 * @return float

 */

 

if(!function_exists('openpay_price_truncate')) {

    function openpay_price_truncate($val, $f="0")

    {

        if(($p = strpos($val, '.')) !== false) {

            $val = floatval(substr($val, 0, $p + 1 + $f));

        }

        return $val;

    }   

}





add_action('admin_head', 'openpay_minmax');



function openpay_minmax() {

?>

<script type="text/javascript" >

jQuery(document).ready(function($) {



    $('.openpayajax').click(function(){

        var data = {

            action: 'openpay_minmax',

        };



        // since 2.8 ajaxurl is always defined in the admin header and points to admin-ajax.php

        $.post(ajaxurl, data, function(response) {

            alert('' + response);

			window.location.reload();

        });

    });





});

</script>

<?php

}



add_action('wp_ajax_openpay_minmax', 'min_max_price');



function min_max_price() {



    $jamAuthToken = determine_plugin_data('merchant_id');

    $workingKey = determine_plugin_data('working_key');

    $serviceBaseApiURL = determine_plugin_mode(1);

    $urlMethodName = "MinMaxPurchasePrice"; 

    $xml = '<MinMaxPurchasePrice>

    <JamAuthToken>'.$jamAuthToken.'</JamAuthToken>

    </MinMaxPurchasePrice>';

    // echo  $xml;

    // exit;

  

    $curl = curl_init();



   // var_dump($serviceBaseApiURL.$urlMethodName);



    curl_setopt_array($curl, array(

    CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

    CURLOPT_RETURNTRANSFER => true,

    CURLOPT_CUSTOMREQUEST => "POST",

    CURLOPT_POSTFIELDS => $xml,

    CURLOPT_HTTPHEADER => array(

    "cache-control: no-cache",

    "content-type: application/xml",

    )

    ));



    $xmlResponse = curl_exec($curl);

   

    $parseXML = simplexml_load_string($xmlResponse);

	$array = get_object_vars($parseXML);

					if($array['status'] == 0)

					{

$ops = get_option('woocommerce_openpay_settings');



if(!is_array($ops)){

	$ops = array();	 

}



$ops['minimum_checkout'] = $array['MinPrice'];

$ops['maximum_checkout'] = $array['MaxPrice'];



update_option('woocommerce_openpay_settings',$ops);



					echo "Minimum & Maximum value imported successfully!";    

					}else{

					echo 'Can not import Min Max Value. Please try after 24 Hour!';

					}

					

              

                

    curl_close($curl);

exit;

   // return $parseXML;

   

}







function action_woocommerce_order_refunded($order_get_id, $refund_get_id){

    $refund_amount = $_POST['refunda'];

    

    $order_id = $_POST['order_id']; 

    //$order_id = $order_get_id;

    $plan_id = get_post_meta( $order_id, '_openpay_planid', true ); 

    $order = new WC_Order( $order_id );

    $order_total = $order->get_total(); 



    $refund_meta = get_post_meta($refund_get_id);

    $_refund_amount = $refund_amount;

    //$_refund_amount = isset($refund_meta['_refund_amount'][0])?$refund_meta['_refund_amount'][0]:0;



    if($_refund_amount<= 0) return false;



    if($order_total == $_refund_amount){

        $FullRefund = 'True';

        $NewPurchasePrice = 0;

    }elseif($order_total > $_refund_amount){

        $FullRefund = 'False';

        $NewPurchasePrice = $order_total - $_refund_amount;

    }else{

        return false;

    }

    

   



    $curl = curl_init();

    $serviceBaseApiURL = determine_plugin_mode(1);

    $urlMethodName = "OnlineOrderReduction";

    $jamAuthToken = determine_plugin_data('merchant_id'); //'30000000000000977|526d44c3-1bff-4fb1-861b-f0788c1c9c22';

    $workingKey = determine_plugin_data('working_key'); //'526d44c3-1bff-4fb1-861b-f0788c1c9c22';



    $xml = "<OnlineOrderReduction>

                <JamAuthToken>".$jamAuthToken."</JamAuthToken>

                <AuthToken>".$workingKey."</AuthToken>

                <PlanID>".$plan_id."</PlanID>

                <NewPurchasePrice>".$NewPurchasePrice."</NewPurchasePrice>

                <FullRefund>".$FullRefund."</FullRefund>

            </OnlineOrderReduction>";



    curl_setopt_array($curl, array(

      CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

      CURLOPT_RETURNTRANSFER => true,

      CURLOPT_CUSTOMREQUEST => "POST",

      CURLOPT_POSTFIELDS => $xml,

      CURLOPT_HTTPHEADER => array(

        "cache-control: no-cache",

        "content-type: application/xml",

      )

    ));



   $res =  curl_exec($curl);

   print_r($res);



}



function check_plan_status($planid) {

    if(empty($planid)) {

        return false;

    }



    $jamAuthToken = determine_plugin_data('merchant_id');

    $workingKey = determine_plugin_data('working_key');

    $serviceBaseApiURL = determine_plugin_mode(1);

    $urlMethodName = "OnlineOrderCapturePayment"; 

    $xml = '<OnlineOrderCapturePayment>

    <JamAuthToken>'.$jamAuthToken.'</JamAuthToken>

    <AuthToken>'.$workingKey.'</AuthToken>

    <PlanID>'.$planid.'</PlanID>

    </OnlineOrderCapturePayment>';

    $curl = curl_init();



    curl_setopt_array($curl, array(

    CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

    CURLOPT_RETURNTRANSFER => true,

    CURLOPT_CUSTOMREQUEST => "POST",

    CURLOPT_POSTFIELDS => $xml,

    CURLOPT_HTTPHEADER => array(

    "cache-control: no-cache",

    "content-type: application/xml",

    )

    ));



    $xmlResponse = curl_exec($curl);

    $parseXML = simplexml_load_string($xmlResponse);

    curl_close($curl);



    return $parseXML;

}



function woocommerce_order_get_openpay_plan_id($PurchasePrice = '', $orderObj = ''){



    if($PurchasePrice):

        global $woocommerce;

        $curl = curl_init();

        $serviceBaseApiURL = determine_plugin_mode(1);

        $urlMethodName = "NewOnlineOrder";

        $jamAuthToken = determine_plugin_data('merchant_id'); //'30000000000000977|526d44c3-1bff-4fb1-861b-f0788c1c9c22';

       

        $JamCallbackURL = $orderObj->get_checkout_order_received_url();

        $JamCancelURL = wc_get_cart_url();

        $JamFailURL = wc_get_checkout_url();

        $order_id = $orderObj->get_id();



       $xml = "<NewOnlineOrder>

                    <JamAuthToken>".$jamAuthToken."</JamAuthToken>

                    <CallbackURL>".$JamCallbackURL."</CallbackURL>

                    <CancelURL>".$JamCancelURL."</CancelURL>

                    <FailURL>".$JamFailURL."</FailURL>

                    <PurchasePrice>".$PurchasePrice."</PurchasePrice>

                    <PlanCreationType>Pending</PlanCreationType>

                    <RetailerOrderNo>".$order_id."</RetailerOrderNo>

                    <FirstName>".$orderObj->billing_first_name."</FirstName>

                    <FamilyName>".$orderObj->billing_last_name."</FamilyName>

                    <Email>".$orderObj->billing_email."</Email>

                    <PhoneNumber>".$orderObj->billing_phone."</PhoneNumber>

                    <ResAddress1>".$orderObj->billing_address_1."</ResAddress1>

                    <ResAddress2>".$orderObj->billing_address_2."</ResAddress2>

                    <ResSuburb>".$orderObj->billing_city."</ResSuburb>

                    <ResState>".$orderObj->billing_state."</ResState>

                    <ResPostCode>".$orderObj->billing_postcode."</ResPostCode>

                    <DelAddress1>".$orderObj->shipping_address_1."</DelAddress1>

                    <DelAddress2>".$orderObj->shipping_address_2."</DelAddress2>

                    <DelSuburb>".$orderObj->shipping_city."</DelSuburb>

                    <DelState>".$orderObj->shipping_state."</DelState>

                    <DelPostCode>".$orderObj->shipping_postcode."</DelPostCode>

                    

                </NewOnlineOrder>";



        curl_setopt_array($curl, array(

          CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

          CURLOPT_RETURNTRANSFER => true,

          CURLOPT_CUSTOMREQUEST => "POST",

          CURLOPT_POSTFIELDS => $xml,

          CURLOPT_HTTPHEADER => array(

            "cache-control: no-cache",

            "content-type: application/xml",

          )

        ));



        $xmlResponse = curl_exec($curl);

        $parseXML = simplexml_load_string($xmlResponse);

        curl_close($curl);

        return $parseXML;

    endif;

}



function openPay_response_parse(){



    if( isset($_REQUEST['status']) && isset($_REQUEST['planid']) && isset($_REQUEST['orderid']) ){



        global $woocommerce;

        $url_order_id = explode( '_', $_REQUEST['orderid'] );

        $order_id = $url_order_id[0];

        if(empty($order_id)) return false;

        $raw_data = (isset($_SERVER['HTTPS']) ? "https://" : "http://") . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

        update_post_meta( $order_id, 'OpenPay_planid', $_REQUEST['planid'] );

        update_post_meta( $order_id, 'OpenPay_status', $_REQUEST['status'] );

        update_post_meta( $order_id, 'OpenPay_raw', $raw_data );

        $order           = new WC_Order($order_id);

        $order_status    = $_REQUEST['status'];

        $transauthorised = false;



        if ($order_status == "LODGED") {

            $transauthorised = true;

            $order->payment_complete();

            $order->add_order_note('Successfully created payment plan in Openpay.<br/>Openpay PlanId : ' . $_REQUEST['planid'] . '<br>RAW Data: ' . $raw_data, 0, 'Openpay' );

            $woocommerce->cart->empty_cart();

            

        } else if ($order_status === "CANCELLED") {

            $order->add_order_note('Openpay payment aborted.<br/>Openpay PlanId : ' . $_REQUEST['planid'] . '<br>RAW Data: ' . $raw_data, 0, 'Openpay' );

            $admin_email    = get_option('admin_email');

            

        } else if ($order_status === "FAILURE") {

            $order->add_order_note('Openpay payment failed.<br/>Openpay PlanId : ' . $_REQUEST['planid'] . '<br>RAW Data: ' . $raw_data, 0, 'Openpay' );



        } else {

            $order->add_order_note('Openpay payment failed.<br/>Openpay PlanId : ' . $_REQUEST['planid'] . '<br>RAW Data: ' . $raw_data, 0, 'Openpay' );

        }

        

        if ($transauthorised == false) {

            $order->update_status('failed');

            $order->add_order_note('Openpay payment failed.<br/>Openpay PlanId : ' . $_REQUEST['planid'] . '<br>RAW Data: ' . $raw_data, 0, 'Openpay');

            $order->add_order_note('The transaction has been declined');

        }        

    }

}



//CUSTOM ORDER STATUS AND TRIGGER WHILE CHANGED

//REF:: https://wisdmlabs.com/blog/add-shipped-order-status-woocommerce/



function wdm_register_shipped_order_status(){



     register_post_status( 'wc-shipped', array(

     'label' => _x('Shipped','wdm'),

     'public' => true,

     'exclude_from_search' => false,

     'show_in_admin_all_list' => true,

     'show_in_admin_status_list' => true,

     'label_count' => _n_noop( 'Shipped <span class="count">(%s)</span>', 'Shipped <span class="count">(%s)</span>' )

    ));

}



function wdm_add_order_meta_box_actions($actions){

   $actions['wdm_shipped'] = __( 'Shipped', 'wdm');

   return $actions; 

}



function add_shipped_to_order_statuses($order_statuses){



      $new_order_statuses = array();

      foreach ( $order_statuses as $key => $status ){

         $new_order_statuses[ $key ] = $status;

         if ( 'wc-completed' === $key ){

            $new_order_statuses['wc-shipped'] = __('Shipped','wdm');    

         }

      }

   return $new_order_statuses;

}



function wdm_order_shipped_callback($order){ 



    $order_id = $order->get_id();

    $plan_id = get_post_meta( $order_id, 'OpenPay_planid', true );

    $curl = curl_init();

    $serviceBaseApiURL = determine_plugin_mode(1);

    $urlMethodName = "OnlineOrderDispatchPlan";

    $jamAuthToken = determine_plugin_data('merchant_id'); //'30000000000000977|526d44c3-1bff-4fb1-861b-f0788c1c9c22';

    $workingKey = determine_plugin_data('working_key'); //'526d44c3-1bff-4fb1-861b-f0788c1c9c22';



    $xml = "<OnlineOrderDispatchPlan>

                <JamAuthToken>".$jamAuthToken."</JamAuthToken>

                <PlanID>".$plan_id."</PlanID>

            </OnlineOrderDispatchPlan>";



    //echo $xml;

    curl_setopt_array($curl, array(

      CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

      CURLOPT_RETURNTRANSFER => true,

      CURLOPT_CUSTOMREQUEST => "POST",

      CURLOPT_POSTFIELDS => $xml,

      CURLOPT_HTTPHEADER => array(

        "cache-control: no-cache",

        "content-type: application/xml",

      )

    ));



    $xmlResponse = curl_exec($curl);

    //print_r($xmlResponse);exit;

    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {

        echo "cURL Error #:" . $err;

        return "error";

    } else {

        $xml = simplexml_load_string($xmlResponse);

        $json = json_encode($xml);

        echo $json;

    }

}



function wdm_order_status_shipped_callback($order_id){



    $plan_id = get_post_meta( $order_id, 'OpenPay_planid', true );

    $curl = curl_init();

    $serviceBaseApiURL = determine_plugin_mode(1);

    $urlMethodName = "OnlineOrderDispatchPlan";

    $jamAuthToken = determine_plugin_data('merchant_id'); //'30000000000000977|526d44c3-1bff-4fb1-861b-f0788c1c9c22';

    $workingKey = determine_plugin_data('working_key'); //'526d44c3-1bff-4fb1-861b-f0788c1c9c22';



    $xml = "<OnlineOrderDispatchPlan>

                <JamAuthToken>".$jamAuthToken."</JamAuthToken>

                <PlanID>".$plan_id."</PlanID>

            </OnlineOrderDispatchPlan>";



    //echo $xml;

    curl_setopt_array($curl, array(

      CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

      CURLOPT_RETURNTRANSFER => true,

      CURLOPT_CUSTOMREQUEST => "POST",

      CURLOPT_POSTFIELDS => $xml,

      CURLOPT_HTTPHEADER => array(

        "cache-control: no-cache",

        "content-type: application/xml",

      )

    ));



    $xmlResponse = curl_exec($curl);

    //print_r($xmlResponse);exit;

    $err = curl_error($curl);

    curl_close($curl);

    if ($err) {

        echo "cURL Error #:" . $err;

        return "error";

    } else {

        $xml = simplexml_load_string($xmlResponse);

        $json = json_encode($xml);

        echo $json;

    }

}



function wdm_add_shipped_in_bulk_action(){



    global $post_type;

    if ( 'shop_order' == $post_type ) {

        wp_register_style('wdm_shipping_icon_css_handler',plugins_url('assets/css/wdm_shipping_icon.css',__FILE__));

        wp_enqueue_style('wdm_shipping_icon_css_handler');

    ?>

    <script type="text/javascript">

        jQuery(function() {

            jQuery('<option>').val('mark_shipped').text('<?php _e( 'Mark shipped', 'woocommerce' )?>').appendTo("select[name='action']");

            jQuery('<option>').val('mark_shipped').text('<?php _e( 'Mark shipped', 'woocommerce' )?>').appendTo("select[name='action2']");

            title_text = jQuery('.column-order_status .shipped').html();

            jQuery('.column-order_status .shipped').attr('alt',title_text);

            jQuery('.column-order_status .shipped').empty();

            jQuery('.column-order_status .shipped').append('<icon class="icon-local-shipping"></icon>');

            jQuery('.column-order_status .shipped').css('text-indent','0');

        });

    </script>

    <?php

    }

}



function wdm_bulk_action_shipping_callback(){



    $wp_list_table = _get_list_table( 'WP_Posts_List_Table' );

    $action = $wp_list_table->current_action();



    switch ( $action ) {

    case 'mark_shipped' :

        $new_status = 'shipped';

        $report_action = 'marked_shipped';

        break;

    default :

        return;

    }

    

    $post_ids = array_map( 'absint', (array) $_REQUEST['post'] );



    foreach ( $post_ids as $post_id ) {

        $order = wc_get_order( $post_id );

        $order->update_status( $new_status, __( 'Order status changed by bulk edit:', 'woocommerce' ) );

        $changed++;

    }



    $sendback = add_query_arg( array( 'post_type' => 'shop_order', $report_action => true, 'changed' => $changed, 'ids' => join( ',', $post_ids ) ), '' );

    wp_redirect( $sendback );

    exit();

}



function determine_plugin_mode($trigger = ''){



            if($trigger):

            $woocommerce_openpay_settings = get_option('woocommerce_openpay_settings');

            $countrycode = $woocommerce_openpay_settings['country'];

            $sandboxmode = $woocommerce_openpay_settings['sandbox'];



           if(  $countrycode == 'UK' ){

            $serviceBaseApiURL = ($sandboxmode == 'yes') ? 'https://integration.training.myopenpay.co.uk/JamServiceImpl.svc/' : 'https://integration.myopenpay.co.uk/JamServiceImpl.svc/';

             

            }else{

            $serviceBaseApiURL = ($sandboxmode == 'yes') ? 'https://retailer.myopenpay.com.au/ServiceTraining/JAMServiceImpl.svc/' : 'https://retailer.myopenpay.com.au/ServiceLive/JAMServiceImpl.svc/';

              

            }



            return $serviceBaseApiURL;

            endif;

        }



function determine_plugin_data($key = ''){



    if($key):

    $woocommerce_openpay_settings = get_option('woocommerce_openpay_settings');

    return $woocommerce_openpay_settings[$key];

    endif;

}



function hook_woocommerce_thankyou(){

    return true;

}



//add_action( 'init', 'determine_plugin_mode' );

//add_action( 'init', 'determine_plugin_data' );

//add_action( 'woocommerce_order_refunded', 'action_woocommerce_order_refunded', 10, 2 );

add_action( 'init', 'wdm_register_shipped_order_status');

add_action( 'woocommerce_order_actions', 'wdm_add_order_meta_box_actions' );

add_filter( 'wc_order_statuses', 'add_shipped_to_order_statuses' );

add_action( 'woocommerce_order_action_wdm_shipped', 'wdm_order_shipped_callback', 10, 1 );

add_action( 'woocommerce_order_status_shipped', 'wdm_order_status_shipped_callback', 10, 1);

add_action( 'admin_footer', 'wdm_add_shipped_in_bulk_action',11);

add_action( 'load-edit.php', 'wdm_bulk_action_shipping_callback' );

add_action( 'woocommerce_thankyou', 'hook_woocommerce_thankyou');

//add_action( 'init','woocommerce_order_get_openpay_plan_id');

//add_action( 'init', 'openPay_response_parse');

add_action( 'woocommerce_before_checkout_form', 'script_admin_footer_function' );

add_action( 'woocommerce_after_cart_table', 'script_admin_footer_function' );

add_filter( 'woocommerce_available_payment_gateways', 'bbloomer_gateway_disable_shipping' );

add_filter('woocommerce_thankyou_order_received_text','alter_order_received_text',10,2);



function script_admin_footer_function() {

    

    $minimum_checkout = determine_plugin_data('minimum_checkout');

    $maximum_checkout = determine_plugin_data('maximum_checkout');

    if(!is_checkout() && !is_cart()) return;

    global $woocommerce;

    $cart_total = $woocommerce->cart->total;

    if($cart_total<$minimum_checkout){

        echo '<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">

              <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

              <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>';

        printf( '<div align="center" class="alert %1$s"><p>%2$s</p></div>', 'alert-info', 'Openpay payment method has been disabled, as it requires minimum $'.$minimum_checkout.' to checkout. Please add $'.($minimum_checkout-$cart_total).' more to your cart to use Openpay.' );

    }

    if($cart_total>$maximum_checkout){

        echo '<link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/css/bootstrap.min.css">

              <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

              <script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.7/js/bootstrap.min.js"></script>';

        printf( '' );

    }

}



function bbloomer_gateway_disable_shipping( $available_gateways ) {

    

    global $woocommerce;

    $minimum_checkout = determine_plugin_data('minimum_checkout');

    $maximum_checkout = determine_plugin_data('maximum_checkout');

    $cart_total = $woocommerce->cart->total;

    if($cart_total<$minimum_checkout) unset( $available_gateways['openpay'] );

    if($cart_total>$maximum_checkout) unset( $available_gateways['openpay'] );

    return $available_gateways;

}



function alter_order_received_text($msg,$order) {



if(!empty($_GET['planid'])) {

        $planid = $_GET['planid'];

        $order_status = $_REQUEST['status'];

        $plandetails = check_plan_status($planid);

        $status = (int) $plandetails->status;

        $orderstatus = (string) $plandetails->OrderStatus;

        $planstatus = (string) $plandetails->PlanStatus;

        update_post_meta($order->get_id(), '_openpay_planid', $planid);



        if($status > 0 ) {

            $error_reason = (string) $plandetails->reason;

            $msg = __('Payment error: '.$error_reason, WC_OPENPAY_TEXT_DOMAIN);

            $order->add_order_note( __($error_reason, WC_OPENPAY_TEXT_DOMAIN));

            $order->update_status( 'failed', __( 'Payment was declined by Openpay.', WC_OPENPAY_TEXT_DOMAIN) );

            return $msg;

        }



        if($status==0) {

            $msg  = "Thank you for shopping with us. Your account has been charged and your transaction is successful. We will be shipping your order to you soon.";

            // Add order note

            $order->add_order_note( sprintf( __( 'Openpay payment approved (PlanID: %1$s)', 'woocommerce' ), $planid ) );

            // Payment complete

            $order->payment_complete();

            $order->update_status('processing');

        }elseif($orderstatus=='Rejected' || $orderstatus=='Denied') {

            $admin_email    = get_option('admin_email');

            $msg = 'Oh! Something went wrong. Payment was declined. Have any questions? Please retry or email to : ' . $admin_email;

            $order->update_status( 'failed', __( 'Payment was declined by Openpay.', WC_OPENPAY_TEXT_DOMAIN) );

            $order->add_order_note( __( 'Openpay payment declined', 'woocommerce' ) );       

        }else{

            $admin_email    = get_option('admin_email');

            $msg = 'Oh! Something went wrong. Payment was declined. Have any questions? Please retry or email to : ' . $admin_email;

            $order->update_status( 'failed', __( 'Payment was declined by Openpay.', WC_OPENPAY_TEXT_DOMAIN) );

            $order->add_order_note( __( 'Openpay payment declined', 'woocommerce' ) );

        }



    }

    return $msg;

}



function check_order_status($planid) {



    if(empty($planid)) {

        return false;

    }



    $jamAuthToken = determine_plugin_data('merchant_id');

    $workingKey = determine_plugin_data('working_key');

    $serviceBaseApiURL = determine_plugin_mode(1);

    $urlMethodName = "OnlineOrderStatus"; 

    $xml = '<OnlineOrderStatus>

    <JamAuthToken>'.$jamAuthToken.'</JamAuthToken>

    <AuthToken>'.$workingKey.'</AuthToken>

    <PlanID>'.$planid.'</PlanID>

    </OnlineOrderStatus>';

    $curl = curl_init();



    curl_setopt_array($curl, array(

    CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,

    CURLOPT_RETURNTRANSFER => true,

    CURLOPT_CUSTOMREQUEST => "POST",

    CURLOPT_POSTFIELDS => $xml,

    CURLOPT_HTTPHEADER => array(

    "cache-control: no-cache",

    "content-type: application/xml",

    )

    ));



    $xmlResponse = curl_exec($curl);

    $parseXML = simplexml_load_string($xmlResponse);

    curl_close($curl);



    return $parseXML;



}



remove_action( 'woocommerce_cancel_unpaid_orders', 'wc_cancel_unpaid_orders' );

add_action( 'woocommerce_cancel_unpaid_orders', 'openpay_online_orders_status_check' );



function openpay_online_orders_status_check() {

    $held_duration = get_option( 'woocommerce_hold_stock_minutes' );





    if ( $held_duration < 1 || 'yes' !== get_option( 'woocommerce_manage_stock' ) ) { return; } $data_store = WC_Data_Store::load( 'order' ); $unpaid_orders = $data_store->get_unpaid_orders( strtotime( '-' . absint( $held_duration ) . ' MINUTES', current_time( 'timestamp' ) ) );



    if ( $unpaid_orders ) {

        foreach ( $unpaid_orders as $unpaid_order ) {

            $order = wc_get_order( $unpaid_order );



        $plan_id = get_post_meta( $unpaid_order, '_openpay_planid', true );

        $payment_m = get_post_meta( $order->id, '_payment_method', true );

        

        //$planid = '3000000017442';

        if ( $payment_m == 'openpay' ) {

        $plandetails = check_order_status($plan_id);

        $status = (int) $plandetails->status;

        $orderstatus = (string) $plandetails->OrderStatus;

        $planstatus = (string) $plandetails->PlanStatus;

        update_post_meta($order->get_id(), '_openpay_planid', $plan_id);

         if($status==0 && $orderstatus=='Approved' && $planstatus=='Active') {

            $order->add_order_note( sprintf( __( 'Openpay payment approved (PlanID: %1$s)', 'woocommerce' ), $plan_id ) );

            $order->add_order_note( sprintf( __( 'Openpay payment (PlanID: %1$s)', 'woocommerce' ), $payment_m ) );

            // Payment complete

            $order->payment_complete();

            $order->update_status('processing');

        }else{

           $order->update_status( 'cancelled', __( 'Unpaid order cancelled - time limit reached.', 'woocommerce' ) );

            $order->add_order_note( __( 'Openpay payment declined', 'woocommerce' ) );

            



        }

    }

  

            }

        }

  

    wp_clear_scheduled_hook( 'woocommerce_cancel_unpaid_orders' );

    wp_schedule_single_event( time() + ( absint( $held_duration ) * 60 ), 'woocommerce_cancel_unpaid_orders' );

}