<?php
/**
* 2020 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayResultModuleFrontController extends ModuleFrontController
{
    public function postProcess()
    {
        $planid = Tools::getValue('planid');
        $respStatus = Tools::getValue('status');
        $respCartid = (int)Tools::getValue('orderid');
        $cart = Context::getContext()->cart;
        $backendParams = OpenpayAdminConfigFormHelper::getConfigFormValues();
        $purchasePrice = 0;

        if ($respCartid !== $cart->id) {
            $this->setErrorAndRedirect('Current cartid is not same', 'cart');
        }
        if ($respStatus == 'LODGED') {
            try {
                /** @var $paymentmanager \BusinessLayer\Openpay\PaymentManager */
                $paymentmanager = new \BusinessLayer\Openpay\PaymentManager($backendParams);
                $paymentmanager->setUrlAttributes(array($planid));
                $response = $paymentmanager->getOrder();
                $purchasePrice = $response->purchasePrice;         
            } catch(\Exception $e) {
                $this->setErrorAndRedirect($e->getMessage(), 'cart');
            }
            $totalFromCart = $cart->getOrderTotal(true, \Cart::BOTH);
            if ((int)($totalFromCart * 100) == $purchasePrice) {
                try {
                    $customer = Context::getContext()->customer;
                    $this->module->validateOrder(
                        $cart->id,
                        Configuration::get('PS_OS_PREPARATION'),
                        (float) $cart->getOrderTotal(true, Cart::BOTH),
                        $this->module->displayName,
                        '',
                        array(),
                        $this->context->currency->id,
                        false,
                        $customer->secure_key
                    );
                } catch(\Exception $e) {
                    $this->setErrorAndRedirect($e->getMessage(), 'cart');
                }
                $orderid = (int)$this->module->currentOrder;
                $order = new Order($orderid);
                OpenpayOrder::store($orderid, $planid);
                $otherData = new \stdClass();
                $otherData->orderid = $order->reference;
                try {
                    /** @var $paymentmanager \BusinessLayer\Openpay\PaymentManager */
                    $paymentmanager = new \BusinessLayer\Openpay\PaymentManager($backendParams);
                    $paymentmanager->setUrlAttributes(array($planid));
                    $paymentmanager->setShopdata(null, $otherData);
                    $response = $paymentmanager->getCapture();
                    $status = Configuration::get('PS_OS_PAYMENT');
                    $history = new OrderHistory();
                    $history->id_order = $orderid;
                    $history->changeIdOrderState($status, $orderid);
                    $history->add();
                    
                    $confirmationURL = 'index.php?controller=order-confirmation'
                        . '&id_cart=' . $cart->id
                        . '&id_module=' . (int)$this->module->id
                        . '&id_order=' . $orderid
                        . '&key=' . $customer->secure_key;
                    Tools::redirect($confirmationURL);
                } catch (Exception $ex) {
                    $this->setErrorAndRedirect($ex->getMessage(), 'order');
                }
            } else {
                $this->setErrorAndRedirect(null,
                    'cart',
                    'Cart price is different to Openpay plan amount.'
                );
            }
        } else {
            $this->setErrorAndRedirect(
                null,
                'order',
                'Openpay transaction was cancelled. Please try again.'
            );
        }
    }
    
    /**
     * write Error message in Logfile and message in Frontend
     * redirect to page
     * 
     * @param string|null $log
     * @param string $redirectpage
     * @param string|null $message
     */
    protected function setErrorAndRedirect($log, $redirectpage, $message = null)
    {
        if ($log != null) {
            OpenpayLogger::getInstance()->addLog($log);
        }
        if ($message == null) {
            $message = 'There has been an error processing your order.';
        }
        $this->context->cookie->openpay_error_message = $this->module->l($message);
        Tools::redirect($this->context->link->getPageLink($redirectpage));
    }
}
