<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

class OpenpayPaymentProcessModuleFrontController extends ModuleFrontController
{
    public $display_column_left = false;
    public $display_column_right = false;
    
    /**
     * Redirect to Openpay site
     * 
     * @return mixed
     */
    public function initContent()
    {
        parent::initContent();
            
        $otherData = new stdClass();
        $otherData->origin = "Online";
        $otherData->planCreationType = "pending";
        $otherData->merchantRedirectUrl = $this->context->link->getModuleLink('openpay', 'result');
        $backendParams = OpenpayAdminConfigFormHelper::getConfigFormValues();
        
        try {
            /** @var $paymentmanager \BusinessLayer\Openpay\PaymentManager */
            $paymentmanager = new \BusinessLayer\Openpay\PaymentManager($backendParams);
            $paymentmanager->setShopdata($this->context, $otherData);
            $token = $paymentmanager->getToken();
            
            $paymentmanager->setShopdata(null, null, $token, null, $backendParams);
            $paymentPage = $paymentmanager->getPaymentPage('redirect', false, 'GET');
            
        } catch (Exception $ex) {
            OpenpayLogger::getInstance()->addLog($ex->getMessage());
            $this->context->cookie->openpay_error_message = $this->module->l('There has been an error processing your order.');
            Tools::redirect($this->context->link->getPageLink('order'));
        }   
        
        $this->context->smarty->assign(array(
            'paymentpage' => $paymentPage,
            'dir' => _PS_MODULE_DIR_
        ));

        $this->setTemplate('module:openpay/views/templates/front/redirect.tpl');
    }
}
