<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

require_once(dirname(__FILE__).'../../../../../config/config.inc.php');

class OpenpayMinMaxModuleFrontController extends ModuleFrontController
{
    /**
     *  Update MinMax
     */
    public function postProcess()
    {
        $params = Tools::getValue('params');
        
        if ($params['user'] && $params['password']) {
            $backofficeParams = OpenpayAdminConfigFormHelper::getConfigFormValues();
            $backofficeParams['OPENPAY_MODE'] = $params['mode'];
            $backofficeParams['OPENPAY_REGION'] = $params['region'];
            $backofficeParams['OPENPAY_USER'] = $params['user'];
            $backofficeParams['OPENPAY_PASSWORD'] = $params['password'];
            $response = OpenpayCronHelper::getLimits($backofficeParams);
            
            if (array_key_exists('message', $response)) {
                $this->ajaxRenderJson(array(
                    'success' => false,
                    'message' => 'Retailer identity key supplied not valid!'
                ));
                exit;
            }
            $this->ajaxRenderJson(array(
                'success' => true,
                'min' => $response['min'],
                'max' => $response['max']
            ));
        }
    }
    
    /**
     * @param $content
     *
     * @throws PrestaShopException
     */
    protected function ajaxRenderJson($content)
    {
        header('Content-Type: application/json');
        $this->ajaxRender(json_encode($content));
    }
}
