<?php
/**
* 2021 Ideatarmac
*
* NOTICE OF LICENSE
*
*  @author    Ideatarmac UG <www.ideatarmac.com>
*  @copyright Openpay
*  @license   Commercial license
*/

require_once(dirname(__FILE__).'../../../../../config/config.inc.php');

class OpenpayCronLimitModuleFrontController extends ModuleFrontController
{
    /**
     *  Update MinMax
     */
    public function postProcess()
    {
        $sql = "SELECT * FROM " . _DB_PREFIX_ . "configuration WHERE name LIKE '%OPENPAY_MIN%'";
        $configMinValues = Db::getInstance()->ExecuteS($sql);
        foreach ($configMinValues as $value) {
            $backofficeParams = [];
            $enabled = Configuration::get('OPENPAY_ACTIVE', null, $value['id_shop_group'], $value['id_shop']);
            if ($enabled !== '1') {
                continue;
            }
            $backofficeParams['OPENPAY_MODE'] = Configuration::get('OPENPAY_MODE', null, (int)$value['id_shop_group'], (int)$value['id_shop']);
            $backofficeParams['OPENPAY_REGION'] = Configuration::get('OPENPAY_REGION', null, (int)$value['id_shop_group'], (int)$value['id_shop']);
            $backofficeParams['OPENPAY_USER'] = Configuration::get('OPENPAY_USER', null, (int)$value['id_shop_group'], (int)$value['id_shop']);
            $backofficeParams['OPENPAY_PASSWORD'] = Configuration::get('OPENPAY_PASSWORD', null, (int)$value['id_shop_group'], (int)$value['id_shop']);
            $response = OpenpayCronHelper::getLimits($backofficeParams);
            
            Configuration::updateValue('OPENPAY_MIN', $response['min'], false, (int)$value['id_shop_group'], (int)$value['id_shop']);
            Configuration::updateValue('OPENPAY_MAX', $response['max'], false, (int)$value['id_shop_group'], (int)$value['id_shop']);
        }
        exit;
    }
}
