<?php
class ModelExtensionPaymentOpenPay extends Model {
	public function getMethod($address, $total) {
		$this->load->language('extension/payment/openpay');

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "zone_to_geo_zone WHERE geo_zone_id = '" . (int)$this->config->get('payment_openpay_geo_zone_id') . "' AND country_id = '" . (int)$address['country_id'] . "' AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");

		$method_data = array();

		if ($this->config->get('payment_openpay_total') > $total || $this->config->get('payment_openpay_total_max') < $total) {
			$method_data = array(
				'code'       => 'openpay',
				'title'      => $this->language->get('text_title'),
				'terms'      => 'Minimum Order Price should be greater than or equals to '.$this->config->get('payment_openpay_total').' or Maximum Order Price sould be less than or equals to '.$this->config->get('payment_openpay_total_max'),
				'sort_order' => $this->config->get('payment_openpay_sort_order'),
				'radio'      => 'disable'
			);
			$status = false;
		} elseif (!$this->config->get('payment_openpay_geo_zone_id')) {
			$status = true;
		} elseif ($query->num_rows) {
			$status = true;
		} else {
			$status = false;
		}

		$currencies = array(
			'AUD',
			'CAD',
			'EUR',
			'GBP',
			'JPY',
			'USD',
			'NZD',
			'CHF',
			'HKD',
			'SGD',
			'SEK',
			'DKK',
			'PLN',
			'NOK',
			'HUF',
			'CZK',
			'ILS',
			'MXN',
			'MYR',
			'BRL',
			'PHP',
			'TWD',
			'THB',
			'TRY',
			'RUB'
		);

		if (!in_array(strtoupper($this->session->data['currency']), $currencies)) {
			$status = false;
		}

		if ($status) {
			$method_data = array(
				'code'       => 'openpay',
				'title'      => $this->language->get('text_title'),
				'terms'      => '',
				'sort_order' => $this->config->get('payment_openpay_sort_order')
			);
		}

		return $method_data;
	}
}
