<?php
class ControllerExtensionPaymentOpenPay extends Controller {
	public function index() {
		$this->load->language('extension/payment/openpay');

		$data['text_testmode'] = $this->language->get('text_testmode');
		$data['button_confirm'] = $this->language->get('button_confirm');
		$data['testmode'] = $this->config->get('payment_openpay_mode');

		$countrycode = $this->config->get('payment_openpay_country');
		$sandboxmode = $this->config->get('payment_openpay_mode');
		if($countrycode == 'AU')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceTraining/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesTraining/';
			}else{
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceLive/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesLive/';
			}
        }

        if($countrycode == 'UK')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://integration.training.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.training.myopenpay.co.uk/';
			}else{
				$serviceBaseApiURL = 'https://integration.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.myopenpay.co.uk/';
			}
        }

		$callbackUrl = $this->url->link('extension/payment/openpay/callback', '', true);
		$data['jamAuthToken'] = $this->config->get('payment_openpay_merchantId');
		$data['workingKey'] = '526d44c3-1bff-4fb1-861b-f0788c1c9c22';

		$this->load->model('checkout/order');

		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);

    	$data['purchasePrice'] = $this->currency->format($order_info['total'], $order_info['currency_code'], $order_info['currency_value'], false);

		//-------------------------------------------------- curl to get plan ID
		$urlMethodName = "NewOnlineOrder";
		$jamCallBackURL = $callbackUrl;
		$data['cancelUrl'] = $callbackUrl;
		$data['failUrl'] = $callbackUrl;
		$data['orderNumber'] = $order_info['order_id'];
		$data['firstName'] = html_entity_decode($order_info['firstname'], ENT_QUOTES, 'UTF-8');
		$data['lastName'] =  html_entity_decode($order_info['lastname'], ENT_QUOTES, 'UTF-8');
		$data['email'] = $order_info['email'];
		$data['address1'] = html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8');
		$data['address2'] = html_entity_decode($order_info['payment_address_2'], ENT_QUOTES, 'UTF-8');
		$data['city'] = html_entity_decode($order_info['payment_city'], ENT_QUOTES, 'UTF-8');
		$data['state'] = html_entity_decode($order_info['payment_zone'], ENT_QUOTES, 'UTF-8');
		$data['postcode'] = html_entity_decode($order_info['payment_postcode'], ENT_QUOTES, 'UTF-8');
		$data['telephone'] = $order_info['telephone'];
		$data['shippingaddress1'] = html_entity_decode($order_info['shipping_address_1'], ENT_QUOTES, 'UTF-8');
		$data['shippingaddress2'] = html_entity_decode($order_info['shipping_address_2'], ENT_QUOTES, 'UTF-8');
		$data['shippingcity'] = html_entity_decode($order_info['shipping_city'], ENT_QUOTES, 'UTF-8');
		$data['shippingstate'] = html_entity_decode($order_info['shipping_zone'], ENT_QUOTES, 'UTF-8');
		$data['shippingpostcode'] = html_entity_decode($order_info['shipping_postcode'], ENT_QUOTES, 'UTF-8');

		// call this to get the PlanID
		$requestJsonPayload = $this->getXmlJSONRequest($serviceBaseApiURL, $urlMethodName, $data['jamAuthToken'], $data['workingKey'], $data['purchasePrice'], "", $jamCallBackURL, $data['cancelUrl'], $data['failUrl'], $data['orderNumber'], $data['firstName'], $data['lastName'], $data['email'], $data['address1'], $data['address2'], $data['city'], $data['state'], $data['postcode'], $data['telephone'], $data['shippingaddress1'], $data['shippingaddress2'], $data['shippingcity'], $data['shippingstate'], $data['shippingpostcode']);

		$data['jamPlanId'] = $requestJsonPayload["PlanID"];
		$data['TransactionToken'] = $requestJsonPayload["TransactionToken"];

		//------------------------------------------------------------------end curl

		if ($order_info) {
			$data['item_name'] = html_entity_decode($this->config->get('config_name'), ENT_QUOTES, 'UTF-8');

			$data['products'] = array();

			foreach ($this->cart->getProducts() as $product) {
				$option_data = array();

				foreach ($product['option'] as $option) {
					if ($option['type'] != 'file') {
						$value = $option['value'];
					} else {
						$upload_info = $this->model_tool_upload->getUploadByCode($option['value']);

						if ($upload_info) {
							$value = $upload_info['name'];
						} else {
							$value = '';
						}
					}
					$option_data[] = array(
						'name'  => $option['name'],
						'value' => (utf8_strlen($value) > 20 ? utf8_substr($value, 0, 20) . '..' : $value)
					);
				}

				$data['products'][] = array(
					'name'     => htmlspecialchars($product['name']),
					'model'    => htmlspecialchars($product['model']),
					'price'    => $this->currency->format($product['price'], $order_info['currency_code'], false, false),
					'quantity' => $product['quantity'],
					'option'   => $option_data,
					'weight'   => $product['weight']
				);
			}

			$data['discount_amount_cart'] = 0;

			$total = $this->currency->format($order_info['total'] - $this->cart->getSubTotal(), $order_info['currency_code'], false, false);

			if ($total > 0) {
				$data['products'][] = array(
					'name'     => $this->language->get('text_total'),
					'model'    => '',
					'price'    => $total,
					'quantity' => 1,
					'option'   => array(),
					'weight'   => 0
				);
			} else {
				$data['discount_amount_cart'] -= $total;
			}

			$data['jamCallBackURL'] = $jamCallBackURL;
			$data['jamPrice'] = $data['purchasePrice'];

			$data['currency_code'] = $order_info['currency_code'];
			$data['first_name'] = html_entity_decode($order_info['payment_firstname'], ENT_QUOTES, 'UTF-8');
			$data['last_name'] = html_entity_decode($order_info['payment_lastname'], ENT_QUOTES, 'UTF-8');
			$data['address1'] = html_entity_decode($order_info['payment_address_1'], ENT_QUOTES, 'UTF-8');
			$data['address2'] = html_entity_decode($order_info['payment_address_2'], ENT_QUOTES, 'UTF-8');
			$data['city'] = html_entity_decode($order_info['payment_city'], ENT_QUOTES, 'UTF-8');
			$data['state'] = html_entity_decode($order_info['payment_zone'], ENT_QUOTES, 'UTF-8');
			$data['zip'] = html_entity_decode($order_info['payment_postcode'], ENT_QUOTES, 'UTF-8');
			$data['country'] = $order_info['payment_iso_code_2'];
			$data['email'] = $order_info['email'];
			$data['invoice'] = $this->session->data['order_id'] . ' - ' . html_entity_decode($order_info['payment_firstname'], ENT_QUOTES, 'UTF-8') . ' ' . html_entity_decode($order_info['payment_lastname'], ENT_QUOTES, 'UTF-8');
			$data['lc'] = $this->session->data['language'];

			$this->addPlanIDToOrderTable();
			$this->db->query("UPDATE " . DB_PREFIX . "order SET plan_id ='" . $this->db->escape($requestJsonPayload["PlanID"]) . "' WHERE order_id = '" . (int)$order_info['order_id'] . "'");

			$data['actionURL'] = $this->getHandOverUrl($handOverUrl, $jamCallBackURL, $data['jamAuthToken'], $requestJsonPayload["PlanID"],$data['TransactionToken'],
								  $order_info['order_id'], $data['jamPrice'], $data['first_name'], $data['last_name'],
							  	  $data['email'], $data['address1'], $data['address2'], $data['city'], $data['state'], $data['zip']);

			$data['cancel_return'] = $this->url->link('checkout/checkout', '', true);


			if (!$this->config->get('payment_openpay_transaction')) {
				$data['paymentaction'] = 'authorization';
			} else {
				$data['paymentaction'] = 'sale';
			}

			$data['custom'] = $this->session->data['order_id'];
			$data['return'] = $this->url->link('extension/payment/openpay/callback', '', true);
			return $this->load->view('extension/payment/openpay', $data);
		}
	}

	public function getXmlJSONRequest($serviceBaseApiURL, $urlMethodName, $jamAuthToken, $workingKey, $purchasePrice=null, $planId=null,$jamCallBackURL, $cancelUrl, $failUrl, $orderNumber=null, $firstName=null, $lastName=null, $email=null, $address1=null, $address2=null, $city=null, $state=null, $postcode=null,$telephone=null, $shippingaddress1=null, $shippingaddress2=null, $shippingcity=null, $shippingstate=null, $shippingpostcode=null){
		$curl = curl_init();

		$xml = '<' . $urlMethodName . '>' . "\n";
        $xml .= "\t" . '<JamAuthToken>';
        $xml .= $jamAuthToken;
        $xml .= '</JamAuthToken>' . "\n";
        $xml .= "\t" . '<AuthToken>';
        $xml .= $workingKey;
        $xml .= '</AuthToken>' . "\n";

        if ($urlMethodName == 'NewOnlineOrder') {
            $xml .= "\t" . '<CallbackURL>';
            $xml .= $jamCallBackURL;
            $xml .= '</CallbackURL>' . "\n";

            $xml .= "\t" . '<CancelURL>';
            $xml .= $cancelUrl;
            $xml .= '</CancelURL>' . "\n";

            $xml .= "\t" . '<FailURL>';
            $xml .= $failUrl;
            $xml .= '</FailURL>' . "\n";
        }
        if ($purchasePrice) {
            $xml .= "\t" . '<PurchasePrice>';
            $xml .= $purchasePrice;
            $xml .= '</PurchasePrice>' . "\n";
        }
        if ($urlMethodName == 'NewOnlineOrder') {

            $xml .= "\t" . '<PlanCreationType>';
            $xml .= "pending";
            $xml .= '</PlanCreationType>' . "\n";

            $xml .= "\t" . '<RetailerOrderNo>';
            $xml .= $orderNumber;
            $xml .= '</RetailerOrderNo>' . "\n";

            $xml .= "\t" . '<FirstName>';
            $xml .= $firstName;
            $xml .= '</FirstName>' . "\n";

            $xml .= "\t" . '<FamilyName>';
            $xml .= $lastName;
            $xml .= '</FamilyName>' . "\n";

            $xml .= "\t" . '<Email>';
            $xml .= $email;
            $xml .= '</Email>' . "\n";

            $xml .= "\t" . '<DateOfBirth>';
            $xml .= '';
            $xml .= '</DateOfBirth>' . "\n";

            $xml .= "\t" . '<PhoneNumber>';
            $xml .= $telephone;
            $xml .= '</PhoneNumber>' . "\n";

            $xml .= "\t" . '<ResAddress1>';
            $xml .= $address1;
            $xml .= '</ResAddress1>' . "\n";

            $xml .= "\t" . '<ResAddress2>';
            $xml .= $address2;
            $xml .= '</ResAddress2>' . "\n";

            $xml .= "\t" . '<ResSuburb>';
            $xml .= $city;
            $xml .= '</ResSuburb>' . "\n";

            $xml .= "\t" . '<ResState>';
            $xml .= $state;
            $xml .= '</ResState>' . "\n";

            $xml .= "\t" . '<ResPostCode>';
            $xml .= $postcode;
            $xml .= '</ResPostCode>' . "\n";

            $xml .= "\t" . '<DelAddress1>';
            $xml .= $shippingaddress1;
            $xml .= '</DelAddress1>' . "\n";

            $xml .= "\t" . '<DelAddress2>';
            $xml .= $shippingaddress2;
            $xml .= '</DelAddress2>' . "\n";

            $xml .= "\t" . '<DelSuburb>';
            $xml .= $shippingcity;
            $xml .= '</DelSuburb>' . "\n";

            $xml .= "\t" . '<DelState>';
            $xml .= $shippingstate;
            $xml .= '</DelState>' . "\n";

            $xml .= "\t" . '<DelPostCode>';
            $xml .= $shippingpostcode;
            $xml .= '</DelPostCode>' . "\n";

        }
        if ($planId) {
            $xml .= "\t" . '<PlanID>';
            $xml .= $planId;
            $xml .= '</PlanID>' . "\n";
        }
        $xml .= '</' . $urlMethodName . '>' . "\n";

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => $xml,
		  CURLOPT_HTTPHEADER => array(
			"cache-control: no-cache",
			"content-type: application/xml",
		  )
		));

		$xmlResponse = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);

		if ($err) {
			echo "cURL Error #:" . $err;
			return "error";
		} else {
			$xml = simplexml_load_string($xmlResponse);
			$json = json_encode($xml);
			$array = json_decode($json,TRUE);

			return $array;
		}


	}

	public function getHandOverUrl($handOverUrl, $jamCallbackURL, $jamAuthToken, $planID, $transactionToken, $orderID, $jamPrice, $first_name, $last_name, $email, $addr1, $addr2, $city, $state, $zip) {
		$url  = $handOverUrl;
		$url .= '?TransactionToken=' . urlencode($transactionToken);
		return $url;
	}


	public function callback() {
		
	
		$this->load->language('extension/payment/openpay');
		$data['testmode'] = $this->config->get('payment_openpay_mode');
		if (isset($_GET['orderid'])) {
			$order_id = $_GET['orderid'];
		} else {
			$order_id = 0;
		}

		if(isset($_GET["planid"])){
			$countrycode = $this->config->get('payment_openpay_country');
			$sandboxmode = $this->config->get('payment_openpay_mode');
			if($countrycode == 'AU')
	        {
	            if($sandboxmode==1){
					$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceTraining/JAMServiceImpl.svc/';
					$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesTraining/';
				}else{
					$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceLive/JAMServiceImpl.svc/';
					$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesLive/';
				}
	        }

	        if($countrycode == 'UK')
	        {
	            if($sandboxmode==1){
					$serviceBaseApiURL = 'https://integration.training.myopenpay.co.uk/JamServiceImpl.svc/';
					$handOverUrl = 'https://websales.training.myopenpay.co.uk/';
				}else{
					$serviceBaseApiURL = 'https://integration.myopenpay.co.uk/JamServiceImpl.svc/';
					$handOverUrl = 'https://websales.myopenpay.co.uk/';
				}
	        }

		
			$data['jamAuthToken'] = $this->config->get('payment_openpay_merchantId');
			$data['workingKey'] = $this->config->get('payment_openpay_workingKey');
		}

		$this->load->model('checkout/order');
		$data['status'] = "";
		if(isset($_GET["status"]) && isset($_GET["planid"]) && $_GET['status'] == "CANCELLED") {
			$data['status'] = "cancelled";
			$this->model_checkout_order->addOrderHistory($_GET['orderid'], '7');
			$this->response->redirect($this->url->link('checkout/checkout')."&openPayStatus=".$data['status']);
		} else if(isset($_GET["status"])  && isset($_GET["planid"]) && $_GET['status'] == "LODGED"){
            
			$urlMethodName = "OnlineOrderCapturePayment";
			$jamCallBackURL = $this->url->link('extension/payment/openpay/callback', '', true);//'https://'.$_SERVER['SERVER_NAME'];
			$plan_id = $_GET["planid"];

			$requestJsonPayload = $this->getXmlJSONRequest($serviceBaseApiURL, $urlMethodName, $data['jamAuthToken'], $data['workingKey'], "", $plan_id, $jamCallBackURL, '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '', '');
			
			
			if($requestJsonPayload['status']){
				$finalResponseStatus = $requestJsonPayload['status'];
			}
			else{
				$finalResponseStatus='';
			}
			 
			if($requestJsonPayload['PlanID']){
			    $finalResponsePlanId = $requestJsonPayload['PlanID'];
			}else{
				$finalResponsePlanId='';
			}
			
			if($finalResponseStatus == 0 && $finalResponsePlanId != '')
			{
	            $this->model_checkout_order->addOrderHistory($_GET['orderid'], '2');
			    $this->response->redirect($this->url->link('checkout/success'));
			}
			else
			{
				$this->model_checkout_order->addOrderHistory($_GET['orderid'], '1');
			    $this->response->redirect($this->url->link('checkout/failure'));
			}
			
		} else {
			$data['status'] = "failure";
			$this->model_checkout_order->addOrderHistory($_GET['orderid'], '10');
			$this->response->redirect($this->url->link('checkout/checkout')."&openPayStatus=".$data['status']);
		}
	}

	public function addPlanIDToOrderTable(){
		$isModelField = FALSE;
		$result = $this->db->query( "DESCRIBE `".DB_PREFIX."order`;" );
		foreach ($result->rows as $row) {
			if ($row['Field'] == 'plan_id') {
				$isModelField = TRUE;
				break;
			}
		}
		if (!$isModelField) {
			$sql = "ALTER TABLE ".DB_PREFIX."order ADD plan_id BIGINT( 11 )";
			$this->db->query( $sql );
		}

	}
}
