<?php
class ControllerExtensionPaymentOpenpay extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/payment/openpay');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('setting/setting');

    	if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('payment_openpay', $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
	    $data['entry_merchantId'] = $this->language->get('entry_merchantId');
		$data['entry_apiUrl'] = $this->language->get('entry_apiUrl');
		$data['entry_handoverUrl'] = $this->language->get('entry_handoverUrl');
		$data['entry_test'] = $this->language->get('entry_test');
		$data['entry_total'] = $this->language->get('entry_total');
		$data['entry_total_max'] = $this->language->get('entry_total_max');
		$data['entry_canceled_reversal_status'] = $this->language->get('entry_canceled_reversal_status');
		$data['entry_completed_status'] = $this->language->get('entry_completed_status');
		$data['entry_denied_status'] = $this->language->get('entry_denied_status');
		$data['entry_expired_status'] = $this->language->get('entry_expired_status');
		$data['entry_failed_status'] = $this->language->get('entry_failed_status');
		$data['entry_pending_status'] = $this->language->get('entry_pending_status');
		$data['entry_processed_status'] = $this->language->get('entry_processed_status');
		$data['entry_refunded_status'] = $this->language->get('entry_refunded_status');
		$data['entry_reversed_status'] = $this->language->get('entry_reversed_status');
		$data['entry_voided_status'] = $this->language->get('entry_voided_status');
		$data['entry_country'] = $this->language->get('entry_country');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_sort_order'] = $this->language->get('entry_sort_order');
		$data['entry_cron_set'] = $this->language->get('entry_cron_set');
		$data['entry_cron_schedule'] = $this->language->get('entry_cron_schedule');
		$data['entry_cron_url'] = $this->language->get('entry_cron_url');

		$data['help_total'] = $this->language->get('help_total');
		$data['help_total_max'] = $this->language->get('help_total_max');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['tab_general'] = $this->language->get('tab_general');
		$data['tab_order_status'] = $this->language->get('tab_order_status');
		$data['help_test'] = $this->language->get('help_test');

        if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		if (isset($this->error['merchantId'])) {
			$data['error_merchantId'] = $this->error['merchantId'];
		} else {
			$data['error_merchantId'] = '';
		}

		if (isset($this->error['country'])) {
			$data['error_country'] = $this->error['country'];
		} else {
			$data['error_country'] = '';
		}

		if (isset($this->error['apiUrl'])) {
			$data['error_apiUrl'] = $this->error['apiUrl'];
		} else {
			$data['error_apiUrl'] = '';
		}

		if (isset($this->error['handoverUrl'])) {
			$data['error_handoverUrl'] = $this->error['handoverUrl'];
		} else {
			$data['error_handoverUrl'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/payment/openpay', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/payment/openpay', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=payment', true);

		$data['admin_user_token'] = $this->session->data['user_token'];

		if (isset($this->request->post['payment_openpay_merchantId'])) {
			$data['payment_openpay_merchantId'] = $this->request->post['payment_openpay_merchantId'];
		} else {
			$data['payment_openpay_merchantId'] = $this->config->get('payment_openpay_merchantId');
		}

     	if (isset($this->request->post['payment_openpay_country'])) {
			$data['payment_openpay_country'] = $this->request->post['payment_openpay_country'];
		} else {
			$data['payment_openpay_country'] = $this->config->get('payment_openpay_country');
		}

		if (isset($this->request->post['payment_openpay_mode'])) {
			$data['payment_openpay_mode'] = $this->request->post['payment_openpay_mode'];
		} else {
			$data['payment_openpay_mode'] = $this->config->get('payment_openpay_mode');
		}

		if (isset($this->request->post['payment_openpay_total'])) {
			$data['payment_openpay_total'] = $this->request->post['payment_openpay_total'];
		} else {
			$data['payment_openpay_total'] = $this->config->get('payment_openpay_total');
		}

		if (isset($this->request->post['payment_openpay_total_max'])) {
			$data['payment_openpay_total_max'] = $this->request->post['payment_openpay_total_max'];
		} else {
			$data['payment_openpay_total_max'] = $this->config->get('payment_openpay_total_max');
		}

		$this->load->model('localisation/order_status');

		$data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

		if (isset($this->request->post['payment_openpay_status'])) {
			$data['payment_openpay_status'] = $this->request->post['payment_openpay_status'];
		} else {
			$data['payment_openpay_status'] = $this->config->get('payment_openpay_status');
		}

		if (isset($this->request->post['payment_openpay_sort_order'])) {
			$data['payment_openpay_sort_order'] = $this->request->post['payment_openpay_sort_order'];
		} else {
			$data['payment_openpay_sort_order'] = $this->config->get('payment_openpay_sort_order');
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/payment/openpay', $data));
	}

	private function validate() {
		$this->load->language('extension/payment/openpay');

		if (!$this->user->hasPermission('modify', 'extension/payment/openpay')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['payment_openpay_merchantId']) {
			$this->error['merchantId'] = $this->language->get('error_merchantId');
		}
		
	    if (!$this->request->post['payment_openpay_country']) {
	      $this->error['country'] = $this->language->get('error_country');
	    }

		return !$this->error;
	}

	public function getXmlJSONRequest(){

		$this->load->model('extension/payment/openpay');
		$order_id = $_GET['order_id'];
		$plan_id = $this->model_extension_payment_openpay->getPlanid($order_id);
		$plan_id = $plan_id['plan_id'];
		$curl = curl_init();
		
		$data['testmode'] = $this->config->get('payment_openpay_mode');

		$countrycode = $this->config->get('payment_openpay_country');
		$sandboxmode = $this->config->get('payment_openpay_mode');
		if($countrycode == 'AU')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceTraining/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesTraining/';
			}else{
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceLive/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesLive/';
			}
        }

        if($countrycode == 'UK')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://integration.training.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.training.myopenpay.co.uk/';
			}else{
				$serviceBaseApiURL = 'https://integration.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.myopenpay.co.uk/';
			}
        }

		$urlMethodName = "OnlineOrderDispatchPlan";
		$data['jamAuthToken'] = $this->config->get('payment_openpay_merchantId');
		$data['country'] = $this->config->get('payment_openpay_country');


		$xml = "<OnlineOrderDispatchPlan>
					<JamAuthToken>".$data['jamAuthToken']."</JamAuthToken>
					<PlanID>".$plan_id."</PlanID>
				</OnlineOrderDispatchPlan>";

		curl_setopt_array($curl, array(
		  CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => $xml,
		  CURLOPT_HTTPHEADER => array(
			"cache-control: no-cache",
			"content-type: application/xml",
		  )
		));

		$xmlResponse = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);
		if ($err) {
			echo "cURL Error #:" . $err;
			return "error";
		} else {
			$xml = simplexml_load_string($xmlResponse);
			$json = json_encode($xml);
			echo $json;
		}
	}

	public function getXmlJSONRequestForRefund(){

		$this->load->model('extension/payment/openpay');
		$order_id = $_GET['order_id'];
		$plan_id = $this->model_extension_payment_openpay->getPlanid($order_id);
		$plan_id = $plan_id['plan_id'];
		$curl = curl_init();
		
		$data['testmode'] = $this->config->get('payment_openpay_mode');

		$countrycode = $this->config->get('payment_openpay_country');
		$sandboxmode = $this->config->get('payment_openpay_mode');
		if($countrycode == 'AU')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceTraining/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesTraining/';
			}else{
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceLive/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesLive/';
			}
        }

        if($countrycode == 'UK')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://integration.training.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.training.myopenpay.co.uk/';
			}else{
				$serviceBaseApiURL = 'https://integration.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.myopenpay.co.uk/';
			}
        }

		$urlMethodName = "OnlineOrderReduction";
		$jamAuthToken = $this->config->get('payment_openpay_merchantId');
		$country = $this->config->get('payment_openpay_country');
		$xml = "<OnlineOrderReduction>
					<JamAuthToken>".$jamAuthToken."</JamAuthToken>
					<PlanID>".$plan_id."</PlanID>
					<NewPurchasePrice>0.00</NewPurchasePrice>
					<FullRefund>True</FullRefund>
				</OnlineOrderReduction>";

		//echo $xml;
		curl_setopt_array($curl, array(
		  CURLOPT_URL => $serviceBaseApiURL.$urlMethodName,
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_CUSTOMREQUEST => "POST",
		  CURLOPT_POSTFIELDS => $xml,
		  CURLOPT_HTTPHEADER => array(
			"cache-control: no-cache",
			"content-type: application/xml",
		  )
		));

		$xmlResponse = curl_exec($curl);
		$err = curl_error($curl);
		curl_close($curl);
		if ($err) {
			echo "cURL Error #:" . $err;
			return "error";
		} else {
			$xml = simplexml_load_string($xmlResponse);
			$json = json_encode($xml);
			echo $json;
		}
	}


	public function runminmax() {
		$countrycode = $this->config->get('payment_openpay_country');
		$sandboxmode = $this->config->get('payment_openpay_mode');
		if($countrycode == 'AU')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceTraining/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesTraining/';
			}else{
				$serviceBaseApiURL = 'https://retailer.myopenpay.com.au/ServiceLive/JAMServiceImpl.svc/';
				$handOverUrl = 'https://retailer.myopenpay.com.au/WebSalesLive/';
			}
        }

        if($countrycode == 'UK')
        {
            if($sandboxmode==1){
				$serviceBaseApiURL = 'https://integration.training.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.training.myopenpay.co.uk/';
			}else{
				$serviceBaseApiURL = 'https://integration.myopenpay.co.uk/JamServiceImpl.svc/';
				$handOverUrl = 'https://websales.myopenpay.co.uk/';
			}
        }
        
        $jamAuthToken = $this->config->get('payment_openpay_merchantId');
        $country = $this->config->get('payment_openpay_country');
	    $curl = curl_init();
        $urlMethodName = "MinMaxPurchasePrice";
		$xml = "<MinMaxPurchasePrice> 
            <JamAuthToken>".$jamAuthToken."</JamAuthToken>
            </MinMaxPurchasePrice>";

		curl_setopt_array($curl, array( 
            CURLOPT_URL => $serviceBaseApiURL.$urlMethodName, 
            CURLOPT_RETURNTRANSFER => true, 
            CURLOPT_CUSTOMREQUEST => "POST", 
            CURLOPT_POSTFIELDS => $xml, 
            CURLOPT_HTTPHEADER => array( "cache-control: no-cache", "content-type: application/xml", ) 
        ));

		$xmlResponse = curl_exec($curl);
        $err = curl_error($curl); 
        curl_close($curl);
        if ($err) 
        { 
            echo "cURL Error #:" . $err; return "error"; 
        } 
        else 
        { 
            $xml = simplexml_load_string($xmlResponse); 
            $array = get_object_vars($xml);
            if($array['status'] == 0){
                $this->load->model('setting/setting');
	    		$arrSetting  = array();
	    		$arrSetting['payment_openpay_merchantId'] = $this->config->get('payment_openpay_merchantId');
	    		$arrSetting['payment_openpay_country'] = $this->config->get('payment_openpay_country');
	    		$arrSetting['payment_openpay_mode'] = $this->config->get('payment_openpay_mode');
	    		$arrSetting['payment_openpay_status'] = $this->config->get('payment_openpay_status');
	    		$arrSetting['payment_openpay_sort_order'] = $this->config->get('payment_openpay_sort_order');
	    		$arrSetting['payment_openpay_total'] = $array['MinPrice'];
	    		$arrSetting['payment_openpay_total_max'] = $array['MaxPrice'];
	    		$this->model_setting_setting->editSetting('payment_openpay', $arrSetting);
	    		$this->session->data['success'] = $this->language->get('text_success');               
            }
        }   
	}

}
